/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.schema;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.springframework.core.annotation.AliasFor;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyToMapConverter;
import org.springframework.data.neo4j.core.schema.CompositePropertyConverterFactory;
import org.springframework.data.util.TypeInformation;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD})
@Inherited
@ConvertWith(converterFactory=CompositePropertyConverterFactory.class)
@API(status=API.Status.STABLE, since="6.0")
public @interface CompositeProperty {
    @AliasFor(annotation=ConvertWith.class, value="converter")
    public Class<? extends Neo4jPersistentPropertyToMapConverter> converter() default DefaultToMapConverter.class;

    @AliasFor(annotation=ConvertWith.class, value="converterRef")
    public String converterRef() default "";

    public String prefix() default "";

    public String delimiter() default ".";

    public Class<? extends BiFunction<Phase, String, String>> transformKeysWith() default NoopTransformation.class;

    public static final class DefaultToMapConverter<K>
    implements Neo4jPersistentPropertyToMapConverter<K, Map<K, Object>> {
        private final UnaryOperator<Map<K, Object>> mapPostProcessor = UnaryOperator.identity();
        private final TypeInformation<?> typeInformationForValues;

        DefaultToMapConverter(TypeInformation<?> typeInformationForValues) {
            this.typeInformationForValues = typeInformationForValues;
        }

        @Override
        public Map<K, Value> decompose(@Nullable Map<K, Object> property, Neo4jConversionService conversionService) {
            if (property == null) {
                return Collections.emptyMap();
            }
            HashMap decomposed = new HashMap(property.size());
            property.forEach((k, v) -> decomposed.put(k, conversionService.writeValue(v, this.typeInformationForValues, null)));
            return decomposed;
        }

        @Override
        public Map<K, Object> compose(Map<K, Value> source, Neo4jConversionService conversionService) {
            HashMap composed = new HashMap(source.size());
            source.forEach((k, v) -> composed.put(k, conversionService.readValue((Value)v, this.typeInformationForValues, null)));
            return (Map)this.mapPostProcessor.apply(composed);
        }
    }

    public static final class NoopTransformation
    implements BiFunction<Phase, String, String> {
        @Override
        public String apply(Phase phase, String s) {
            return s;
        }
    }

    public static enum Phase {
        WRITE,
        READ;

    }
}

