/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import org.jspecify.annotations.Nullable;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;

final class NullSafeNeo4jPersistentPropertyConverter<T>
implements Neo4jPersistentPropertyConverter<T> {
    private final Neo4jPersistentPropertyConverter<T> delegate;
    private final boolean passNullOnWrite;
    private final boolean forCollection;

    NullSafeNeo4jPersistentPropertyConverter(Neo4jPersistentPropertyConverter<T> delegate, boolean passNullOnWrite, boolean forCollection) {
        this.delegate = delegate;
        this.passNullOnWrite = passNullOnWrite;
        this.forCollection = forCollection;
    }

    @Override
    public Value write(@Nullable T source) {
        if (source == null) {
            return this.passNullOnWrite ? this.delegate.write(source) : Values.NULL;
        }
        return this.delegate.write(source);
    }

    @Override
    public @Nullable T read(@Nullable Value source) {
        return source == null || source.isNull() ? null : (T)this.delegate.read(source);
    }

    boolean isForCollection() {
        return this.forCollection;
    }
}

