/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.domain.Window;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.FluentQuerySupport;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.repository.query.FluentQuery;
import org.springframework.data.support.PageableExecutionUtils;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.2")
final class ReactiveFluentQueryByExample<S, R>
extends FluentQuerySupport<R>
implements FluentQuery.ReactiveFluentQuery<R> {
    private final Neo4jMappingContext mappingContext;
    private final Example<S> example;
    private final ReactiveFluentFindOperation findOperation;
    private final Function<Example<S>, Mono<Long>> countOperation;
    private final Function<Example<S>, Mono<Boolean>> existsOperation;

    ReactiveFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, ReactiveFluentFindOperation findOperation, Function<Example<S>, Mono<Long>> countOperation, Function<Example<S>, Mono<Boolean>> existsOperation) {
        this(example, resultType, mappingContext, findOperation, countOperation, existsOperation, Sort.unsorted(), null, null);
    }

    ReactiveFluentQueryByExample(Example<S> example, Class<R> resultType, Neo4jMappingContext mappingContext, ReactiveFluentFindOperation findOperation, Function<Example<S>, Mono<Long>> countOperation, Function<Example<S>, Mono<Boolean>> existsOperation, Sort sort, @Nullable Integer limit, @Nullable Collection<String> properties) {
        super(resultType, sort, limit, properties);
        this.mappingContext = mappingContext;
        this.example = example;
        this.findOperation = findOperation;
        this.countOperation = countOperation;
        this.existsOperation = existsOperation;
    }

    public FluentQuery.ReactiveFluentQuery<R> sortBy(Sort sort) {
        return new ReactiveFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort.and(sort), this.limit, this.properties);
    }

    public FluentQuery.ReactiveFluentQuery<R> limit(int limit) {
        return new ReactiveFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort, limit, this.properties);
    }

    public <NR> FluentQuery.ReactiveFluentQuery<NR> as(Class<NR> resultType) {
        return new ReactiveFluentQueryByExample<S, NR>(this.example, resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation);
    }

    public FluentQuery.ReactiveFluentQuery<R> project(Collection<String> properties) {
        return new ReactiveFluentQueryByExample<S, R>(this.example, this.resultType, this.mappingContext, this.findOperation, this.countOperation, this.existsOperation, this.sort, this.limit, this.mergeProperties(this.extractAllPaths(properties)));
    }

    public Mono<R> one() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithSort(this.mappingContext, this.example, this.sort, this.limit, this.createIncludedFieldsPredicate())).one();
    }

    public Mono<R> first() {
        return this.all().take(1L).singleOrEmpty();
    }

    public Flux<R> all() {
        return this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithSort(this.mappingContext, this.example, this.sort, this.limit, this.createIncludedFieldsPredicate())).all();
    }

    public Mono<Page<R>> page(Pageable pageable) {
        Flux results = this.findOperation.find(this.example.getProbeType()).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithPageable(this.mappingContext, this.example, pageable, this.createIncludedFieldsPredicate())).all();
        return results.collectList().zipWith(this.countOperation.apply(this.example)).map(tuple -> {
            Page page = PageableExecutionUtils.getPage((List)((List)tuple.getT1()), (Pageable)pageable, () -> (Long)tuple.getT2());
            return page;
        });
    }

    public Mono<Window<R>> scroll(ScrollPosition scrollPosition) {
        Condition condition;
        long skip;
        Class domainType = this.example.getProbeType();
        Neo4jPersistentEntity entity = (Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(domainType);
        if (scrollPosition.isInitial()) {
            v0 = 0L;
        } else if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition;
            v0 = offsetScrollPosition.getOffset();
        } else {
            v0 = skip = 0L;
        }
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            condition = CypherAdapterUtils.combineKeysetIntoCondition((Neo4jPersistentEntity)this.mappingContext.getPersistentEntity(this.example.getProbeType()), keysetScrollPosition, this.sort, this.mappingContext.getConversionService());
        } else {
            condition = null;
        }
        Condition condition2 = condition;
        return this.findOperation.find(domainType).as(this.resultType).matching(QueryFragmentsAndParameters.forExampleWithScrollPosition(this.mappingContext, this.example, condition2, this.sort, this.limit == null ? 1 : this.limit + 1, skip, scrollPosition, this.createIncludedFieldsPredicate())).all().collectList().map(rawResult -> this.scroll(scrollPosition, rawResult, entity));
    }

    public Mono<Long> count() {
        return this.countOperation.apply(this.example);
    }

    public Mono<Boolean> exists() {
        return this.existsOperation.apply(this.example);
    }
}

