/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.SortItem;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.domain.OffsetScrollPosition;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.CypherAdapterUtils;
import org.springframework.data.neo4j.repository.query.Predicate;
import org.springframework.data.neo4j.repository.query.PropertyPathWrapper;
import org.springframework.data.neo4j.repository.query.QueryFragments;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.4")
public final class QueryFragmentsAndParameters {
    private static final CypherGenerator cypherGenerator = CypherGenerator.INSTANCE;
    private Map<String, Object> parameters;
    private NodeDescription<?> nodeDescription;
    private final QueryFragments queryFragments;
    private final String cypherQuery;
    private final Sort sort;

    public QueryFragmentsAndParameters(NodeDescription<?> nodeDescription, QueryFragments queryFragments, @Nullable Map<String, Object> parameters, @Nullable Sort sort) {
        this.nodeDescription = nodeDescription;
        this.queryFragments = queryFragments;
        this.parameters = parameters;
        this.cypherQuery = null;
        this.sort = sort == null ? Sort.unsorted() : sort;
    }

    public QueryFragmentsAndParameters(String cypherQuery) {
        this(cypherQuery, null);
    }

    public QueryFragmentsAndParameters(String cypherQuery, @Nullable Map<String, Object> parameters) {
        this.cypherQuery = cypherQuery;
        this.queryFragments = new QueryFragments();
        this.parameters = parameters;
        this.sort = Sort.unsorted();
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public QueryFragments getQueryFragments() {
        return this.queryFragments;
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public NodeDescription<?> getNodeDescription() {
        return this.nodeDescription;
    }

    public void setParameters(Map<String, Object> newParameters) {
        this.parameters = newParameters;
    }

    public Sort getSort() {
        return this.sort;
    }

    public static QueryFragmentsAndParameters forFindById(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__id__", idValues);
        Node container = cypherGenerator.createRootNode(entityMetaData);
        Condition condition = ((Neo4jPersistentProperty)entityMetaData.getIdProperty()).isComposite() ? CypherGenerator.INSTANCE.createCompositePropertyCondition((GraphPropertyDescription)entityMetaData.getIdProperty(), container.getRequiredSymbolicName(), (Expression)Cypher.parameter((String)"__id__")) : entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"));
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)container);
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters, null);
    }

    public static QueryFragmentsAndParameters forFindByAllId(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Condition condition;
        Map<String, Object> parameters = Collections.singletonMap("__ids__", idValues);
        Node container = cypherGenerator.createRootNode(entityMetaData);
        if (((Neo4jPersistentProperty)entityMetaData.getIdProperty()).isComposite()) {
            ArrayList<String> args = new ArrayList<String>();
            for (String key : ((Neo4jPersistentProperty)entityMetaData.getIdProperty()).getOptionalConverter().write(null).keys()) {
                args.add(key);
                args.add((String)container.property(key));
            }
            condition = Cypher.mapOf((Object[])args.toArray()).in((Expression)Cypher.parameter((String)"__ids__"));
        } else {
            condition = entityMetaData.getIdExpression().in((Expression)Cypher.parameter((String)"__ids__"));
        }
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)container);
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters, null);
    }

    public static QueryFragmentsAndParameters forFindAll(Neo4jPersistentEntity<?> entityMetaData) {
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        queryFragments.setCondition(Conditions.noCondition());
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, Collections.emptyMap(), null);
    }

    public static QueryFragmentsAndParameters forExistsById(Neo4jPersistentEntity<?> entityMetaData, Object idValues) {
        Map<String, Object> parameters = Collections.singletonMap("__id__", idValues);
        Node container = cypherGenerator.createRootNode(entityMetaData);
        Condition condition = ((Neo4jPersistentProperty)entityMetaData.getIdProperty()).isComposite() ? CypherGenerator.INSTANCE.createCompositePropertyCondition((GraphPropertyDescription)entityMetaData.getIdProperty(), container.getRequiredSymbolicName(), (Expression)Cypher.parameter((String)"__id__")) : entityMetaData.getIdExpression().isEqualTo((Expression)Cypher.parameter((String)"__id__"));
        QueryFragments queryFragments = new QueryFragments();
        queryFragments.addMatchOn((PatternElement)container);
        queryFragments.setCondition(condition);
        queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForExists(entityMetaData));
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters, null);
    }

    public static QueryFragmentsAndParameters forPageableAndSort(Neo4jPersistentEntity<?> neo4jPersistentEntity, @Nullable Pageable pageable, @Nullable Sort sort) {
        return QueryFragmentsAndParameters.getQueryFragmentsAndParameters(neo4jPersistentEntity, pageable, sort, null, null, null, Collections.emptyMap(), null, null, null);
    }

    static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, null, null, null, null, null, null);
    }

    static QueryFragmentsAndParameters forExampleWithPageable(Neo4jMappingContext mappingContext, Example<?> example, Pageable pageable, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, pageable, null, null, null, null, includeField);
    }

    static QueryFragmentsAndParameters forExampleWithSort(Neo4jMappingContext mappingContext, Example<?> example, Sort sort, @Nullable Integer limit, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, null, null, sort, limit, null, null, includeField);
    }

    static QueryFragmentsAndParameters forExampleWithScrollPosition(Neo4jMappingContext mappingContext, Example<?> example, @Nullable Condition keysetScrollPositionCondition, Sort sort, @Nullable Integer limit, @Nullable Long skip, ScrollPosition scrollPosition, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.forExample(mappingContext, example, keysetScrollPositionCondition, null, sort, limit, skip, scrollPosition, includeField);
    }

    private static QueryFragmentsAndParameters forExample(Neo4jMappingContext mappingContext, Example<?> example, @Nullable Condition keysetScrollPositionCondition, @Nullable Pageable pageable, @Nullable Sort sort, @Nullable Integer limit, @Nullable Long skip, @Nullable ScrollPosition scrollPosition, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        Predicate predicate = Predicate.create(mappingContext, example);
        Map<String, Object> parameters = predicate.getParameters();
        Set<PropertyPathWrapper> propertyPathWrappers = predicate.getPropertyPathWrappers();
        Condition condition = predicate.getCondition();
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)mappingContext.getPersistentEntity(example.getProbeType());
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            if (!keysetScrollPosition.isInitial()) {
                condition = condition.and(keysetScrollPositionCondition);
            }
            QueryFragmentsAndParameters queryFragmentsAndParameters = QueryFragmentsAndParameters.getQueryFragmentsAndParameters(persistentEntity, pageable, sort, null, limit, skip, parameters, condition, includeField, propertyPathWrappers);
            queryFragmentsAndParameters.getQueryFragments().setRequiresReverseSort(keysetScrollPosition.scrollsBackward());
            return queryFragmentsAndParameters;
        }
        return QueryFragmentsAndParameters.getQueryFragmentsAndParameters(persistentEntity, pageable, sort, null, limit, skip, parameters, condition, includeField, propertyPathWrappers);
    }

    @API(status=API.Status.EXPERIMENTAL, since="6.1.7")
    public static QueryFragmentsAndParameters forCondition(Neo4jPersistentEntity<?> entityMetaData, Condition condition) {
        return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, null, null, null, null, null, null);
    }

    static QueryFragmentsAndParameters forConditionAndPageable(Neo4jPersistentEntity<?> entityMetaData, Condition condition, Pageable pageable, java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, pageable, null, null, null, null, includeField);
    }

    static QueryFragmentsAndParameters forConditionAndSort(Neo4jPersistentEntity<?> entityMetaData, Condition condition, Sort sort, @Nullable Integer limit, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, null, sort, null, limit, null, includeField);
    }

    static QueryFragmentsAndParameters forConditionAndSortItems(Neo4jPersistentEntity<?> entityMetaData, Condition condition, @Nullable Collection<SortItem> sortItems) {
        return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, null, null, sortItems, null, null, null);
    }

    static QueryFragmentsAndParameters forConditionWithScrollPosition(Neo4jPersistentEntity<?> entityMetaData, Condition condition, @Nullable Condition keysetCondition, ScrollPosition scrollPosition, @Nullable Sort sort, @Nullable Integer limit, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        long skip = 0L;
        if (scrollPosition instanceof OffsetScrollPosition) {
            OffsetScrollPosition offsetScrollPosition = (OffsetScrollPosition)scrollPosition;
            skip = offsetScrollPosition.isInitial() ? 0L : offsetScrollPosition.getOffset();
            return QueryFragmentsAndParameters.forCondition(entityMetaData, condition, null, sort, null, limit, skip, includeField);
        }
        if (scrollPosition instanceof KeysetScrollPosition) {
            KeysetScrollPosition keysetScrollPosition = (KeysetScrollPosition)scrollPosition;
            if (!scrollPosition.isInitial()) {
                condition = condition.and(keysetCondition);
            }
            QueryFragmentsAndParameters queryFragmentsAndParameters = QueryFragmentsAndParameters.getQueryFragmentsAndParameters(entityMetaData, null, sort, null, limit, skip, Collections.emptyMap(), condition, includeField, null);
            queryFragmentsAndParameters.getQueryFragments().setRequiresReverseSort(keysetScrollPosition.scrollsBackward());
            return queryFragmentsAndParameters;
        }
        throw new IllegalArgumentException("ScrollPosition must be of type OffsetScrollPosition or KeysetScrollPosition. Unexpected type %s found.".formatted(scrollPosition.getClass()));
    }

    private static QueryFragmentsAndParameters forCondition(Neo4jPersistentEntity<?> entityMetaData, Condition condition, @Nullable Pageable pageable, @Nullable Sort sort, @Nullable Collection<SortItem> sortItems, @Nullable Integer limit, @Nullable Long skip, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField) {
        return QueryFragmentsAndParameters.getQueryFragmentsAndParameters(entityMetaData, pageable, sort, sortItems, limit, skip, Collections.emptyMap(), condition, includeField, null);
    }

    private static QueryFragmentsAndParameters getQueryFragmentsAndParameters(Neo4jPersistentEntity<?> entityMetaData, @Nullable Pageable pageable, @Nullable Sort sort, @Nullable Collection<SortItem> sortItems, @Nullable Integer limit, @Nullable Long skip, @Nullable Map<String, Object> parameters, @Nullable Condition condition, @Nullable java.util.function.Predicate<PropertyFilter.RelaxedPropertyPath> includeField, @Nullable Set<PropertyPathWrapper> propertyPathWrappers) {
        QueryFragments queryFragments = new QueryFragments();
        if (propertyPathWrappers != null && !propertyPathWrappers.isEmpty()) {
            Node startNode = Cypher.node((String)entityMetaData.getPrimaryLabel(), (List)entityMetaData.getAdditionalLabels()).named(Constants.NAME_OF_TYPED_ROOT_NODE.apply(entityMetaData));
            ArrayList<PatternElement> relationshipChain = new ArrayList<PatternElement>();
            for (PropertyPathWrapper possiblePathWithRelationship : propertyPathWrappers) {
                relationshipChain.add((PatternElement)((RelationshipPattern)possiblePathWithRelationship.createRelationshipChain((ExposesRelationships<?>)startNode)));
            }
            queryFragments.setMatchOn(relationshipChain);
        } else {
            queryFragments.addMatchOn((PatternElement)cypherGenerator.createRootNode(entityMetaData));
        }
        queryFragments.setCondition(condition);
        if (includeField == null) {
            queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData));
        } else {
            queryFragments.setReturnExpressions(cypherGenerator.createReturnStatementForMatch(entityMetaData, includeField));
            queryFragments.setProjectingPropertyFilter(includeField);
        }
        if (pageable != null) {
            QueryFragmentsAndParameters.adaptPageable(entityMetaData, pageable, queryFragments);
        } else {
            if (sort != null) {
                queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, sort));
            } else if (sortItems != null) {
                queryFragments.setOrderBy(sortItems);
            }
            if (limit != null) {
                queryFragments.setLimit(limit);
            }
            if (skip != null) {
                queryFragments.setSkip(skip);
            }
        }
        return new QueryFragmentsAndParameters(entityMetaData, queryFragments, parameters, sort);
    }

    private static void adaptPageable(Neo4jPersistentEntity<?> entityMetaData, Pageable pageable, QueryFragments queryFragments) {
        Sort pageableSort = pageable.getSort();
        queryFragments.setSkip(pageable.getOffset());
        queryFragments.setLimit(pageable.getPageSize());
        queryFragments.setOrderBy(CypherAdapterUtils.toSortItems(entityMetaData, pageableSort));
    }
}

