/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.aot;

import java.util.Arrays;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.aot.hint.TypeReference;
import org.springframework.data.neo4j.core.mapping.callback.AfterConvertCallback;
import org.springframework.data.neo4j.core.mapping.callback.BeforeBindCallback;
import org.springframework.data.neo4j.core.schema.GeneratedValue;
import org.springframework.data.neo4j.core.support.UUIDStringGenerator;
import org.springframework.data.neo4j.repository.query.QuerydslNeo4jPredicateExecutor;
import org.springframework.data.neo4j.repository.query.ReactiveQuerydslNeo4jPredicateExecutor;
import org.springframework.data.neo4j.repository.query.SimpleQueryByExampleExecutor;
import org.springframework.data.neo4j.repository.query.SimpleReactiveQueryByExampleExecutor;
import org.springframework.data.neo4j.repository.support.SimpleNeo4jRepository;
import org.springframework.data.neo4j.repository.support.SimpleReactiveNeo4jRepository;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.util.ReactiveWrappers;
import org.springframework.lang.Nullable;

public class Neo4jRuntimeHints
implements RuntimeHintsRegistrar {
    public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
        hints.reflection().registerTypes(Arrays.asList(TypeReference.of(SimpleNeo4jRepository.class), TypeReference.of(SimpleQueryByExampleExecutor.class), TypeReference.of(BeforeBindCallback.class), TypeReference.of(AfterConvertCallback.class), TypeReference.of(UUIDStringGenerator.class), TypeReference.of(GeneratedValue.InternalIdGenerator.class), TypeReference.of(GeneratedValue.UUIDGenerator.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        if (ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            hints.reflection().registerTypes(Arrays.asList(TypeReference.of(SimpleReactiveQueryByExampleExecutor.class), TypeReference.of(SimpleReactiveNeo4jRepository.class)), builder -> builder.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS}));
        }
        if (QuerydslUtils.QUERY_DSL_PRESENT) {
            Neo4jRuntimeHints.registerQuerydslHints(hints);
        }
    }

    private static void registerQuerydslHints(RuntimeHints hints) {
        hints.reflection().registerType(QuerydslNeo4jPredicateExecutor.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        if (ReactiveWrappers.isAvailable((ReactiveWrappers.ReactiveLibrary)ReactiveWrappers.ReactiveLibrary.PROJECT_REACTOR)) {
            hints.reflection().registerType(ReactiveQuerydslNeo4jPredicateExecutor.class, new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
        }
    }
}

