/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.Conditions;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.Parameter;
import org.neo4j.cypherdsl.core.Property;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.ExampleMatcher;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.support.ExampleMatcherAccessor;
import org.springframework.data.util.DirectFieldAccessFallbackBeanWrapper;

final class Predicate {
    private final Neo4jPersistentEntity neo4jPersistentEntity;
    private Condition condition = Conditions.noCondition();
    private final Map<String, Object> parameters = new HashMap<String, Object>();

    static <S> Predicate create(Neo4jMappingContext mappingContext, Example<S> example) {
        Neo4jPersistentEntity probeNodeDescription = (Neo4jPersistentEntity)mappingContext.getRequiredPersistentEntity(example.getProbeType());
        Collection graphProperties = probeNodeDescription.getGraphProperties();
        DirectFieldAccessFallbackBeanWrapper beanWrapper = new DirectFieldAccessFallbackBeanWrapper(example.getProbe());
        ExampleMatcher matcher = example.getMatcher();
        ExampleMatcher.MatchMode mode = matcher.getMatchMode();
        ExampleMatcherAccessor matcherAccessor = new ExampleMatcherAccessor(matcher);
        Predicate predicate = new Predicate(probeNodeDescription);
        for (GraphPropertyDescription graphProperty : graphProperties) {
            String currentPath = graphProperty.getFieldName();
            if (matcherAccessor.isIgnoredPath(currentPath)) continue;
            boolean internalId = graphProperty.isIdProperty() && probeNodeDescription.isUsingInternalIds();
            String propertyName = graphProperty.getPropertyName();
            ExampleMatcher.PropertyValueTransformer transformer = matcherAccessor.getValueTransformerForPath(currentPath);
            Optional optionalValue = (Optional)transformer.apply(Optional.ofNullable(beanWrapper.getPropertyValue(currentPath)));
            if (optionalValue.isEmpty()) {
                if (internalId || !matcherAccessor.getNullHandler().equals((Object)ExampleMatcher.NullHandler.INCLUDE)) continue;
                predicate.add(mode, Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(probeNodeDescription)), (String[])new String[]{propertyName}).isNull());
                continue;
            }
            Neo4jConversionService conversionService = mappingContext.getConversionService();
            if (graphProperty.isRelationship()) {
                Neo4jQuerySupport.REPOSITORY_QUERY_LOG.error((CharSequence)"Querying by example does not support traversing of relationships.");
                continue;
            }
            if (graphProperty.isIdProperty() && probeNodeDescription.isUsingInternalIds()) {
                predicate.add(mode, predicate.neo4jPersistentEntity.getIdExpression().isEqualTo((Expression)Cypher.literalOf(optionalValue.get())));
                continue;
            }
            Property property = Cypher.property((Expression)((Expression)Constants.NAME_OF_TYPED_ROOT_NODE.apply(probeNodeDescription)), (String[])new String[]{propertyName});
            Parameter parameter = Cypher.parameter((String)propertyName);
            Condition condition = property.isEqualTo((Expression)parameter);
            if (String.class.equals(graphProperty.getActualType())) {
                if (matcherAccessor.isIgnoreCaseForPath(currentPath)) {
                    property = Functions.toLower((Expression)property);
                    parameter = Functions.toLower((Expression)parameter);
                }
                condition = switch (matcherAccessor.getStringMatcherForPath(currentPath)) {
                    default -> throw new IncompatibleClassChangeError();
                    case ExampleMatcher.StringMatcher.DEFAULT, ExampleMatcher.StringMatcher.EXACT -> property.isEqualTo((Expression)parameter);
                    case ExampleMatcher.StringMatcher.CONTAINING -> property.contains((Expression)parameter);
                    case ExampleMatcher.StringMatcher.STARTING -> property.startsWith((Expression)parameter);
                    case ExampleMatcher.StringMatcher.ENDING -> property.endsWith((Expression)parameter);
                    case ExampleMatcher.StringMatcher.REGEX -> property.matches((Expression)parameter);
                };
            }
            predicate.add(mode, condition);
            predicate.parameters.put(propertyName, optionalValue.map(v -> {
                Neo4jPersistentProperty neo4jPersistentProperty = (Neo4jPersistentProperty)graphProperty;
                return conversionService.writeValue(v, neo4jPersistentProperty.getTypeInformation(), neo4jPersistentProperty.getOptionalConverter());
            }).get());
        }
        return predicate;
    }

    private Predicate(Neo4jPersistentEntity neo4jPersistentEntity) {
        this.neo4jPersistentEntity = neo4jPersistentEntity;
    }

    public Condition getCondition() {
        return this.condition;
    }

    StatementBuilder.OrderableOngoingReadingAndWith useWithReadingFragment(BiFunction<NodeDescription<?>, Condition, StatementBuilder.OrderableOngoingReadingAndWith> readingFragmentSupplier) {
        return readingFragmentSupplier.apply(this.neo4jPersistentEntity, this.condition);
    }

    private void add(ExampleMatcher.MatchMode matchMode, Condition additionalCondition) {
        this.condition = switch (matchMode) {
            default -> throw new IncompatibleClassChangeError();
            case ExampleMatcher.MatchMode.ALL -> this.condition.and(additionalCondition);
            case ExampleMatcher.MatchMode.ANY -> this.condition.or(additionalCondition);
        };
    }

    public NodeDescription<?> getNeo4jPersistentEntity() {
        return this.neo4jPersistentEntity;
    }

    public Map<String, Object> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }
}

