/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collection;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.ReactiveNeo4jOperations;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.mapping.PropertyFilter;
import org.springframework.data.neo4j.repository.query.AbstractReactiveNeo4jQuery;
import org.springframework.data.neo4j.repository.query.CypherQueryCreator;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.PartValidator;
import org.springframework.data.neo4j.repository.query.QueryFragmentsAndParameters;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.lang.Nullable;

final class ReactivePartTreeNeo4jQuery
extends AbstractReactiveNeo4jQuery {
    private final PartTree tree;

    public static RepositoryQuery create(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, ProjectionFactory factory) {
        return new ReactivePartTreeNeo4jQuery(neo4jOperations, mappingContext, queryMethod, new PartTree(queryMethod.getName(), ReactivePartTreeNeo4jQuery.getDomainType(queryMethod)), factory);
    }

    private ReactivePartTreeNeo4jQuery(ReactiveNeo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, Neo4jQueryMethod queryMethod, PartTree tree, ProjectionFactory factory) {
        super(neo4jOperations, mappingContext, queryMethod, Neo4jQueryType.fromPartTree(tree), factory);
        this.tree = tree;
        PartValidator validator = new PartValidator(mappingContext, queryMethod);
        this.tree.flatMap(Streamable::stream).forEach(validator::validatePart);
    }

    @Override
    protected <T> PreparedQuery<T> prepareQuery(Class<T> returnedType, Collection<PropertyFilter.ProjectedPath> includedProperties, Neo4jParameterAccessor parameterAccessor, @Nullable Neo4jQueryType queryType, @Nullable Supplier<BiFunction<TypeSystem, MapAccessor, ?>> mappingFunction) {
        CypherQueryCreator queryCreator = new CypherQueryCreator(this.mappingContext, ReactivePartTreeNeo4jQuery.getDomainType(this.queryMethod), Optional.ofNullable(queryType).orElseGet(() -> Neo4jQueryType.fromPartTree(this.tree)), this.tree, parameterAccessor, includedProperties, this::convertParameter, UnaryOperator.identity());
        QueryFragmentsAndParameters queryAndParameters = (QueryFragmentsAndParameters)queryCreator.createQuery();
        return PreparedQuery.queryFor(returnedType).withQueryFragmentsAndParameters(queryAndParameters).usingMappingFunction(mappingFunction).build();
    }
}

