/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.lang.Nullable;

final class NodeDescriptionStore {
    private final Map<String, NodeDescription<?>> nodeDescriptionsByPrimaryLabel = new HashMap();

    NodeDescriptionStore() {
    }

    public boolean containsKey(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.containsKey(primaryLabel);
    }

    public <T> boolean containsValue(DefaultNeo4jPersistentEntity<T> newEntity) {
        return this.nodeDescriptionsByPrimaryLabel.containsValue(newEntity);
    }

    public <T> void put(String primaryLabel, DefaultNeo4jPersistentEntity<T> newEntity) {
        this.nodeDescriptionsByPrimaryLabel.put(primaryLabel, newEntity);
    }

    public Set<Map.Entry<String, NodeDescription<?>>> entrySet() {
        return this.nodeDescriptionsByPrimaryLabel.entrySet();
    }

    public Collection<NodeDescription<?>> values() {
        return this.nodeDescriptionsByPrimaryLabel.values();
    }

    @Nullable
    public NodeDescription<?> get(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.get(primaryLabel);
    }

    @Nullable
    public NodeDescription<?> getNodeDescription(Class<?> targetType) {
        for (NodeDescription<?> nodeDescription : this.values()) {
            if (!nodeDescription.getUnderlyingClass().equals(targetType)) continue;
            return nodeDescription;
        }
        return null;
    }

    public NodeDescriptionAndLabels deriveConcreteNodeDescription(Neo4jPersistentEntity<?> entityDescription, List<String> labels) {
        boolean isConcreteClassThatFulfillsEverything;
        boolean bl = isConcreteClassThatFulfillsEverything = !Modifier.isAbstract(entityDescription.getUnderlyingClass().getModifiers()) && entityDescription.getStaticLabels().containsAll(labels);
        if (labels == null || labels.isEmpty() || isConcreteClassThatFulfillsEverything) {
            return new NodeDescriptionAndLabels(entityDescription, Collections.emptyList());
        }
        Collection haystack = entityDescription.describesInterface() ? this.values() : entityDescription.getChildNodeDescriptionsInHierarchy();
        if (!haystack.isEmpty()) {
            Function<NodeDescription, Integer> count = nodeDescription -> Math.toIntExact(nodeDescription.getStaticLabels().stream().filter(labels::contains).count());
            Optional<Map.Entry> mostMatchingNodeDescription = haystack.stream().filter(nd -> labels.containsAll(nd.getStaticLabels())).collect(Collectors.toMap(Function.identity(), nodeDescription -> (Integer)count.apply((NodeDescription)nodeDescription))).entrySet().stream().max(Comparator.comparingInt(Map.Entry::getValue));
            if (mostMatchingNodeDescription.isPresent()) {
                NodeDescription childNodeDescription = (NodeDescription)mostMatchingNodeDescription.get().getKey();
                List<String> staticLabels = childNodeDescription.getStaticLabels();
                HashSet<String> surplusLabels = new HashSet<String>(labels);
                surplusLabels.removeAll(staticLabels);
                return new NodeDescriptionAndLabels(childNodeDescription, surplusLabels);
            }
        }
        HashSet<String> surplusLabels = new HashSet<String>(labels);
        surplusLabels.remove(entityDescription.getPrimaryLabel());
        surplusLabels.removeAll(entityDescription.getAdditionalLabels());
        return new NodeDescriptionAndLabels(entityDescription, surplusLabels);
    }
}

