/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collections;
import java.util.Map;
import org.springframework.data.neo4j.core.ReactiveFluentFindOperation;
import org.springframework.data.neo4j.core.ReactiveNeo4jTemplate;
import org.springframework.data.neo4j.core.TemplateSupport;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class ReactiveFluentFindOperationSupport
implements ReactiveFluentFindOperation {
    private final ReactiveNeo4jTemplate template;

    ReactiveFluentFindOperationSupport(ReactiveNeo4jTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFluentFindOperation.ExecutableFind<T> find(Class<T> domainType) {
        Assert.notNull(domainType, (String)"DomainType must not be null!");
        return new ExecutableFindSupport<T>(this.template, domainType, domainType, null, Collections.emptyMap());
    }

    private static class ExecutableFindSupport<T>
    implements ReactiveFluentFindOperation.ExecutableFind<T>,
    ReactiveFluentFindOperation.FindWithProjection<T>,
    ReactiveFluentFindOperation.FindWithQuery<T>,
    ReactiveFluentFindOperation.TerminatingFind<T> {
        private final ReactiveNeo4jTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String query;
        private final Map<String, Object> parameters;

        ExecutableFindSupport(ReactiveNeo4jTemplate template, Class<?> domainType, Class<T> returnType, String query, Map<String, Object> parameters) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.query = query;
            this.parameters = parameters;
        }

        @Override
        public <T1> ReactiveFluentFindOperation.FindWithQuery<T1> as(Class<T1> returnType) {
            Assert.notNull(returnType, (String)"ReturnType must not be null!");
            return new ExecutableFindSupport<T1>(this.template, this.domainType, returnType, this.query, this.parameters);
        }

        @Override
        public ReactiveFluentFindOperation.TerminatingFind<T> matching(String query, Map<String, Object> parameters) {
            Assert.notNull((Object)query, (String)"Query must not be null!");
            return new ExecutableFindSupport<T>(this.template, this.domainType, this.returnType, query, parameters);
        }

        @Override
        public Mono<T> one() {
            return this.doFind(TemplateSupport.FetchType.ONE).single();
        }

        @Override
        public Flux<T> all() {
            return this.doFind(TemplateSupport.FetchType.ALL);
        }

        private Flux<T> doFind(TemplateSupport.FetchType fetchType) {
            return this.template.doFind(this.query, this.parameters, this.domainType, this.returnType, fetchType);
        }
    }
}

