/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0.9")
final class TemplateSupport {
    @Nullable
    static Class<?> findCommonElementType(Iterable<?> collection) {
        List allClasses = StreamSupport.stream(collection.spliterator(), true).filter(o -> o != null).map(Object::getClass).collect(Collectors.toList());
        Class candidate = null;
        for (Class type : allClasses) {
            if (candidate == null) {
                candidate = type;
                continue;
            }
            if (candidate == type) continue;
            candidate = null;
            break;
        }
        if (candidate != null) {
            return candidate;
        }
        Predicate<Class> moveUp = c -> c != null && c != Object.class;
        HashSet mostAbstractClasses = new HashSet();
        for (Class type : allClasses) {
            while (moveUp.test(type.getSuperclass())) {
                type = type.getSuperclass();
            }
            mostAbstractClasses.add(type);
        }
        Class clazz = candidate = mostAbstractClasses.size() == 1 ? (Class)mostAbstractClasses.iterator().next() : null;
        if (candidate != null) {
            return candidate;
        }
        List<Set> interfacesPerClass = allClasses.stream().map(c -> Arrays.stream(c.getInterfaces()).collect(Collectors.toSet())).collect(Collectors.toList());
        Set allInterfaces = interfacesPerClass.stream().flatMap(Collection::stream).collect(Collectors.toSet());
        interfacesPerClass.forEach(setOfInterfaces -> allInterfaces.removeIf(iface -> !setOfInterfaces.contains(iface)));
        candidate = allInterfaces.size() == 1 ? (Class)allInterfaces.iterator().next() : null;
        return candidate;
    }

    static Predicate<String> computeIncludePropertyPredicate(List<PropertyDescriptor> includedProperties) {
        if (includedProperties == null) {
            return p -> true;
        }
        Set includedPropertyNames = includedProperties.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        return includedPropertyNames::contains;
    }

    static Map<String, Object> mergeParameters(Statement statement, @Nullable Map<String, Object> parameters) {
        HashMap<String, Object> mergedParameters = new HashMap<String, Object>(statement.getParameters());
        if (parameters != null) {
            mergedParameters.putAll(parameters);
        }
        return mergedParameters;
    }

    private TemplateSupport() {
    }

    static enum FetchType {
        ONE,
        ALL;

    }
}

