/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.1")
final class TemplateSupport {
    @Nullable
    static Class<?> findCommonElementType(Iterable<?> collection) {
        Class<?> candidate = null;
        for (Object val : collection) {
            if (val == null) continue;
            if (candidate == null) {
                candidate = val.getClass();
                continue;
            }
            if (candidate == val.getClass()) continue;
            return null;
        }
        return candidate;
    }

    static Predicate<String> computeIncludePropertyPredicate(List<PropertyDescriptor> includedProperties) {
        if (includedProperties == null) {
            return p -> true;
        }
        Set includedPropertyNames = includedProperties.stream().map(FeatureDescriptor::getName).collect(Collectors.toSet());
        return includedPropertyNames::contains;
    }

    private TemplateSupport() {
    }

    static enum FetchType {
        ONE,
        ALL;

    }
}

