/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.neo4j.core.Neo4jOperations;
import org.springframework.data.neo4j.core.PreparedQuery;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.query.AbstractNeo4jQuery;
import org.springframework.data.neo4j.repository.query.Neo4jParameterAccessor;
import org.springframework.data.neo4j.repository.query.Neo4jQueryMethod;
import org.springframework.data.neo4j.repository.query.Neo4jQuerySupport;
import org.springframework.data.neo4j.repository.query.Neo4jQueryType;
import org.springframework.data.neo4j.repository.query.Neo4jSpelSupport;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.SpelEvaluator;
import org.springframework.data.repository.query.SpelQueryContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class StringBasedNeo4jQuery
extends AbstractNeo4jQuery {
    static final SpelQueryContext SPEL_QUERY_CONTEXT = SpelQueryContext.of(StringBasedNeo4jQuery::parameterNameSource, StringBasedNeo4jQuery::replacementSource);
    private static final String COMMENT_OR_WHITESPACE_GROUP = "(?:\\s|/\\\\*.*?\\\\*/|//.*?$)";
    static final Pattern SKIP_AND_LIMIT_WITH_PLACEHOLDER_PATTERN = Pattern.compile("(?ims).+SKIP(?:\\s|/\\\\*.*?\\\\*/|//.*?$)+\\$(?:\\s|/\\\\*.*?\\\\*/|//.*?$)*(?:(?-i)skip)(?:\\s|/\\\\*.*?\\\\*/|//.*?$)+LIMIT(?:\\s|/\\\\*.*?\\\\*/|//.*?$)+\\$(?:\\s|/\\\\*.*?\\\\*/|//.*?$)*(?:(?-i)limit).*");
    private final SpelEvaluator spelEvaluator;

    static StringBasedNeo4jQuery create(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider, Neo4jQueryMethod queryMethod) {
        Query queryAnnotation = queryMethod.getQueryAnnotation().orElseThrow(() -> new MappingException("Expected @Query annotation on the query method!"));
        boolean requiresCount = queryMethod.isPageQuery();
        boolean supportsCount = queryMethod.isSliceQuery();
        boolean requiresSkipAndLimit = queryMethod.isSliceQuery() || requiresCount;
        boolean countQueryPresent = StringUtils.hasText((String)queryAnnotation.countQuery());
        if (!countQueryPresent) {
            if (requiresCount) {
                throw new MappingException("Expected paging query method to have a count query!");
            }
            if (supportsCount) {
                Neo4jQuerySupport.REPOSITORY_QUERY_LOG.debug(() -> String.format("You provided a string based query returning a slice for '%s.%s'. You might want to consider adding a count query if more slices than you expect are returned.", queryMethod.getRepositoryName(), queryMethod.getName()));
            }
        }
        String cypherTemplate = Optional.ofNullable(queryAnnotation.value()).filter(StringUtils::hasText).orElseThrow(() -> new MappingException("Expected @Query annotation to have a value, but it did not."));
        if (requiresSkipAndLimit && !StringBasedNeo4jQuery.hasSkipAndLimitKeywordsAndPlaceholders(cypherTemplate)) {
            Neo4jQuerySupport.REPOSITORY_QUERY_LOG.warn(() -> String.format("The custom query %n%s%nfor '%s.%s' is supposed to work with a page or slicing query but does not have the required parameter placeholders `$skip` and `$limit`.%nBe aware that those parameters are case sensitive and SDN uses the lower case variant.", cypherTemplate, queryMethod.getRepositoryName(), queryMethod.getName()));
        }
        return new StringBasedNeo4jQuery(neo4jOperations, mappingContext, evaluationContextProvider, queryMethod, cypherTemplate, Neo4jQueryType.fromDefinition(queryAnnotation));
    }

    static StringBasedNeo4jQuery create(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider, Neo4jQueryMethod queryMethod, String cypherTemplate) {
        Assert.hasText((String)cypherTemplate, (String)"Cannot create String based Neo4j query without a cypher template.");
        return new StringBasedNeo4jQuery(neo4jOperations, mappingContext, evaluationContextProvider, queryMethod, cypherTemplate, Neo4jQueryType.DEFAULT);
    }

    private StringBasedNeo4jQuery(Neo4jOperations neo4jOperations, Neo4jMappingContext mappingContext, QueryMethodEvaluationContextProvider evaluationContextProvider, Neo4jQueryMethod queryMethod, String cypherTemplate, Neo4jQueryType queryType) {
        super(neo4jOperations, mappingContext, queryMethod, queryType);
        SpelQueryContext.SpelExtractor spelExtractor = SPEL_QUERY_CONTEXT.parse(cypherTemplate);
        this.spelEvaluator = new SpelEvaluator(evaluationContextProvider, queryMethod.getParameters(), spelExtractor);
    }

    @Override
    protected <T> PreparedQuery<T> prepareQuery(Class<T> returnedType, List<String> includedProperties, Neo4jParameterAccessor parameterAccessor, @Nullable Neo4jQueryType queryType, @Nullable BiFunction<TypeSystem, MapAccessor, ?> mappingFunction, UnaryOperator<Integer> limitModifier) {
        Map<String, Object> boundParameters = this.bindParameters(parameterAccessor, true, limitModifier);
        Neo4jQuerySupport.QueryContext queryContext = new Neo4jQuerySupport.QueryContext(this.queryMethod.getRepositoryName() + "." + this.queryMethod.getName(), this.spelEvaluator.getQueryString(), boundParameters);
        this.replaceLiteralsIn(queryContext);
        this.logWarningsIfNecessary(queryContext, parameterAccessor);
        return PreparedQuery.queryFor(returnedType).withCypherQuery(queryContext.query).withParameters(boundParameters).usingMappingFunction(mappingFunction).build();
    }

    Map<String, Object> bindParameters(Neo4jParameterAccessor parameterAccessor, boolean includePageableParameter, UnaryOperator<Integer> limitModifier) {
        Parameters<Neo4jQueryMethod.Neo4jParameters, Neo4jQueryMethod.Neo4jParameter> formalParameters = parameterAccessor.getParameters();
        HashMap<String, Object> resolvedParameters = new HashMap<String, Object>();
        for (Map.Entry evaluatedParam : this.spelEvaluator.evaluate(parameterAccessor.getValues()).entrySet()) {
            Object value = evaluatedParam.getValue() instanceof Neo4jSpelSupport.LiteralReplacement ? evaluatedParam.getValue() : super.convertParameter(evaluatedParam.getValue());
            resolvedParameters.put((String)evaluatedParam.getKey(), value);
        }
        formalParameters.getBindableParameters().forEach(parameter -> {
            int parameterIndex = parameter.getIndex();
            Object parameterValue = super.convertParameter(parameterAccessor.getBindableValue(parameterIndex));
            parameter.getName().ifPresent(parameterName -> resolvedParameters.put((String)parameterName, parameterValue));
            resolvedParameters.put(Integer.toString(parameterIndex), parameterValue);
        });
        if (formalParameters.hasPageableParameter() && includePageableParameter) {
            Pageable pageable = parameterAccessor.getPageable();
            resolvedParameters.put("limit", limitModifier.apply(pageable.getPageSize()));
            resolvedParameters.put("skip", pageable.getOffset());
        }
        return resolvedParameters;
    }

    @Override
    protected Optional<PreparedQuery<Long>> getCountQuery(Neo4jParameterAccessor parameterAccessor) {
        return this.queryMethod.getQueryAnnotation().map(queryAnnotation -> PreparedQuery.queryFor(Long.class).withCypherQuery(queryAnnotation.countQuery()).withParameters(this.bindParameters(parameterAccessor, false, UnaryOperator.identity())).build());
    }

    private static String parameterNameSource(int index, String originalSpelExpression) {
        return "__SpEL__" + index;
    }

    private static String replacementSource(String originalPrefix, String parameterName) {
        return "$" + parameterName;
    }

    static boolean hasSkipAndLimitKeywordsAndPlaceholders(String queryTemplate) {
        return SKIP_AND_LIMIT_WITH_PLACEHOLDER_PATTERN.matcher(queryTemplate).matches();
    }
}

