/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.driver.Record;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.types.MapAccessor;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.data.neo4j.core.RecordMapAccessor;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.NoRootNodeMappingException;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class PreparedQuery<T> {
    private final Class<T> resultType;
    private final String cypherQuery;
    private final Map<String, Object> parameters;
    @Nullable
    private final BiFunction<TypeSystem, Record, T> mappingFunction;

    public static <CT> RequiredBuildStep<CT> queryFor(Class<CT> resultType) {
        return new RequiredBuildStep(resultType);
    }

    private PreparedQuery(OptionalBuildSteps<T> optionalBuildSteps) {
        this.resultType = optionalBuildSteps.resultType;
        this.mappingFunction = optionalBuildSteps.mappingFunction == null ? null : new AggregatingMappingFunction(optionalBuildSteps.mappingFunction);
        this.cypherQuery = optionalBuildSteps.cypherQuery;
        this.parameters = optionalBuildSteps.parameters;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public Optional<BiFunction<TypeSystem, Record, T>> getOptionalMappingFunction() {
        return Optional.ofNullable(this.mappingFunction);
    }

    boolean resultsHaveBeenAggregated() {
        return this.mappingFunction != null && ((AggregatingMappingFunction)this.mappingFunction).hasAggregated();
    }

    public String getCypherQuery() {
        return this.cypherQuery;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    private static class AggregatingMappingFunction
    implements BiFunction<TypeSystem, Record, Object> {
        private final BiFunction<TypeSystem, MapAccessor, ?> target;
        private final AtomicBoolean aggregated = new AtomicBoolean(false);

        AggregatingMappingFunction(BiFunction<TypeSystem, MapAccessor, ?> target) {
            this.target = target;
        }

        private Collection<?> aggregateList(TypeSystem t, Value value) {
            if (MappingSupport.isListContainingOnly(t.LIST(), t.PATH()).test(value)) {
                LinkedHashSet result = new LinkedHashSet();
                for (Value path : value.values()) {
                    result.addAll(this.aggregatePath(t, path, Collections.emptyList()));
                }
                return result;
            }
            return value.asList(v -> this.target.apply(t, (MapAccessor)v));
        }

        private Collection<?> aggregatePath(TypeSystem t, Value value, List<Map.Entry<String, Value>> additionalValues) {
            Path path = value.asPath();
            LinkedHashSet result = new LinkedHashSet();
            path.iterator().forEachRemaining(segment -> {
                HashMap<String, Value> mapValue = new HashMap<String, Value>();
                mapValue.put("__is_path_segment__", Values.value((boolean)true));
                mapValue.put("__start__", Values.value((Object)segment.start()));
                mapValue.put("__relationship__", Values.value((Object)segment.relationship()));
                mapValue.put("__end__", Values.value((Object)segment.end()));
                additionalValues.forEach(e -> {
                    Value cfr_ignored_0 = (Value)mapValue.put((String)e.getKey(), (Value)e.getValue());
                });
                Value v = Values.value(mapValue);
                try {
                    result.add(this.target.apply(t, (MapAccessor)v));
                }
                catch (NoRootNodeMappingException noRootNodeMappingException) {
                    // empty catch block
                }
            });
            return result;
        }

        @Override
        public Object apply(TypeSystem t, Record r) {
            if (r.size() == 1) {
                Value value = r.get(0);
                if (value.hasType(t.LIST())) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregateList(t, value);
                }
                if (value.hasType(t.PATH())) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregatePath(t, value, Collections.emptyList());
                }
            }
            try {
                return this.target.apply(t, new RecordMapAccessor(r));
            }
            catch (NoRootNodeMappingException e) {
                Map<Boolean, List<Map.Entry>> pathValues = r.asMap(Function.identity()).entrySet().stream().collect(Collectors.partitioningBy(entry -> ((Value)entry.getValue()).hasType(t.PATH())));
                if (pathValues.get(true).size() == 1) {
                    this.aggregated.compareAndSet(false, true);
                    return this.aggregatePath(t, (Value)pathValues.get(true).get(0).getValue(), pathValues.get(false));
                }
                throw e;
            }
        }

        boolean hasAggregated() {
            return this.aggregated.get();
        }
    }

    public static class OptionalBuildSteps<CT> {
        final Class<CT> resultType;
        final String cypherQuery;
        Map<String, Object> parameters = Collections.emptyMap();
        @Nullable
        BiFunction<TypeSystem, MapAccessor, ?> mappingFunction;

        OptionalBuildSteps(Class<CT> resultType, String cypherQuery) {
            this.resultType = resultType;
            this.cypherQuery = cypherQuery;
        }

        public OptionalBuildSteps<CT> withParameters(Map<String, Object> newParameters) {
            this.parameters = new HashMap<String, Object>(newParameters);
            return this;
        }

        public OptionalBuildSteps<CT> usingMappingFunction(@Nullable BiFunction<TypeSystem, MapAccessor, ?> newMappingFunction) {
            this.mappingFunction = newMappingFunction;
            return this;
        }

        public PreparedQuery<CT> build() {
            return new PreparedQuery(this);
        }
    }

    public static class RequiredBuildStep<CT> {
        private final Class<CT> resultType;

        private RequiredBuildStep(Class<CT> resultType) {
            this.resultType = resultType;
        }

        public OptionalBuildSteps<CT> withCypherQuery(String cypherQuery) {
            return new OptionalBuildSteps<CT>(this.resultType, cypherQuery);
        }
    }
}

