/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Driver;
import org.neo4j.driver.Query;
import org.neo4j.driver.QueryRunner;
import org.neo4j.driver.Record;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Value;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.DelegatingMappingFunctionWithNullCheck;
import org.springframework.data.neo4j.core.NamedParameters;
import org.springframework.data.neo4j.core.Neo4jClient;
import org.springframework.data.neo4j.core.Neo4jPersistenceExceptionTranslator;
import org.springframework.data.neo4j.core.ResultSummaries;
import org.springframework.data.neo4j.core.SingleValueMappingFunction;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionManager;
import org.springframework.data.neo4j.core.transaction.Neo4jTransactionUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultNeo4jClient
implements Neo4jClient {
    private final Driver driver;
    private final TypeSystem typeSystem;
    private final ConversionService conversionService;
    private final Neo4jPersistenceExceptionTranslator persistenceExceptionTranslator = new Neo4jPersistenceExceptionTranslator();
    private final Set<Bookmark> bookmarks = new HashSet<Bookmark>();
    private final ReentrantReadWriteLock bookmarksLock = new ReentrantReadWriteLock();

    DefaultNeo4jClient(Driver driver) {
        this.driver = driver;
        this.typeSystem = driver.defaultTypeSystem();
        this.conversionService = new DefaultConversionService();
        new Neo4jConversions().registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DelegatingQueryRunner getQueryRunner(@Nullable String targetDatabase) {
        Transaction queryRunner = Neo4jTransactionManager.retrieveTransaction(this.driver, targetDatabase);
        Set<Bookmark> lastBookmarks = Collections.emptySet();
        if (queryRunner == null) {
            ReentrantReadWriteLock.ReadLock lock = this.bookmarksLock.readLock();
            try {
                lock.lock();
                lastBookmarks = new HashSet<Bookmark>(this.bookmarks);
                queryRunner = this.driver.session(Neo4jTransactionUtils.sessionConfig(false, lastBookmarks, targetDatabase));
            }
            finally {
                lock.unlock();
            }
        }
        return new DelegatingQueryRunner((QueryRunner)queryRunner, lastBookmarks, (usedBookmarks, newBookmark) -> {
            ReentrantReadWriteLock.WriteLock lock = this.bookmarksLock.writeLock();
            try {
                lock.lock();
                this.bookmarks.removeAll((Collection<?>)usedBookmarks);
                this.bookmarks.add((Bookmark)newBookmark);
            }
            finally {
                lock.unlock();
            }
        });
    }

    @Override
    public Neo4jClient.RunnableSpec query(String cypher) {
        return this.query(() -> cypher);
    }

    @Override
    public Neo4jClient.RunnableSpec query(Supplier<String> cypherSupplier) {
        return new DefaultRunnableSpec(cypherSupplier);
    }

    @Override
    public <T> Neo4jClient.OngoingDelegation<T> delegateTo(Function<QueryRunner, Optional<T>> callback) {
        return new DefaultRunnableDelegation<T>(callback);
    }

    private static RuntimeException potentiallyConvertRuntimeException(RuntimeException ex, PersistenceExceptionTranslator exceptionTranslator) {
        DataAccessException resolved = exceptionTranslator.translateExceptionIfPossible(ex);
        return resolved == null ? ex : resolved;
    }

    class DefaultRunnableDelegation<T>
    implements Neo4jClient.RunnableDelegation<T>,
    Neo4jClient.OngoingDelegation<T> {
        private final Function<QueryRunner, Optional<T>> callback;
        @Nullable
        private String targetDatabase;

        DefaultRunnableDelegation(Function<QueryRunner, Optional<T>> callback) {
            this(callback, null);
        }

        DefaultRunnableDelegation(@Nullable Function<QueryRunner, Optional<T>> callback, String targetDatabase) {
            this.callback = callback;
            this.targetDatabase = targetDatabase;
        }

        @Override
        public Neo4jClient.RunnableDelegation in(@Nullable String targetDatabase) {
            this.targetDatabase = Neo4jClient.verifyDatabaseName(targetDatabase);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> run() {
            try (DelegatingQueryRunner queryRunner = DefaultNeo4jClient.this.getQueryRunner(this.targetDatabase);){
                Optional<T> optional = this.callback.apply(queryRunner);
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
        }
    }

    class DefaultRecordFetchSpec<T>
    implements Neo4jClient.RecordFetchSpec<T>,
    Neo4jClient.MappingSpec<T> {
        private final String targetDatabase;
        private final RunnableStatement runnableStatement;
        private BiFunction<TypeSystem, Record, T> mappingFunction;

        DefaultRecordFetchSpec(String targetDatabase, RunnableStatement runnableStatement, BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.targetDatabase = targetDatabase;
            this.runnableStatement = runnableStatement;
            this.mappingFunction = mappingFunction;
        }

        @Override
        public Neo4jClient.RecordFetchSpec<T> mappedBy(BiFunction<TypeSystem, Record, T> mappingFunction) {
            this.mappingFunction = new DelegatingMappingFunctionWithNullCheck<T>(mappingFunction);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> one() {
            try (DelegatingQueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.targetDatabase);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Optional optionalValue = result.hasNext() ? Optional.ofNullable(this.mappingFunction.apply(DefaultNeo4jClient.this.typeSystem, result.single())) : Optional.empty();
                ResultSummaries.process(result.consume());
                Optional optional = optionalValue;
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Optional<T> first() {
            try (DelegatingQueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.targetDatabase);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Optional<T> optionalValue = result.stream().map(this.partialMappingFunction(DefaultNeo4jClient.this.typeSystem)).findFirst();
                ResultSummaries.process(result.consume());
                Optional<T> optional = optionalValue;
                return optional;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Collection<T> all() {
            try (DelegatingQueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.targetDatabase);){
                Result result = this.runnableStatement.runWith(statementRunner);
                Collection values = result.stream().map(this.partialMappingFunction(DefaultNeo4jClient.this.typeSystem)).collect(Collectors.toList());
                ResultSummaries.process(result.consume());
                Collection collection = values;
                return collection;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
        }

        private Function<Record, T> partialMappingFunction(TypeSystem typeSystem) {
            return r -> this.mappingFunction.apply(typeSystem, (Record)r);
        }
    }

    class DefaultRunnableSpec
    implements Neo4jClient.RunnableSpec {
        private RunnableStatement runnableStatement;
        private String targetDatabase;

        DefaultRunnableSpec(Supplier<String> cypherSupplier) {
            this.runnableStatement = new RunnableStatement(cypherSupplier);
        }

        @Override
        public Neo4jClient.RunnableSpecTightToDatabase in(String targetDatabase) {
            this.targetDatabase = Neo4jClient.verifyDatabaseName(targetDatabase);
            return this;
        }

        @Override
        public Neo4jClient.OngoingBindSpec<?, Neo4jClient.RunnableSpecTightToDatabase> bind(@Nullable Object value) {
            return new DefaultOngoingBindSpec<Object>(value);
        }

        @Override
        public Neo4jClient.RunnableSpecTightToDatabase bindAll(Map<String, Object> newParameters) {
            this.runnableStatement.parameters.addAll(newParameters);
            return this;
        }

        @Override
        public <T> Neo4jClient.MappingSpec<T> fetchAs(Class<T> targetClass) {
            return new DefaultRecordFetchSpec(this.targetDatabase, this.runnableStatement, new SingleValueMappingFunction<T>(DefaultNeo4jClient.this.conversionService, targetClass));
        }

        @Override
        public Neo4jClient.RecordFetchSpec<Map<String, Object>> fetch() {
            return new DefaultRecordFetchSpec<Map<String, Object>>(this.targetDatabase, this.runnableStatement, (t, r) -> r.asMap());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public ResultSummary run() {
            try (DelegatingQueryRunner statementRunner = DefaultNeo4jClient.this.getQueryRunner(this.targetDatabase);){
                Result result = this.runnableStatement.runWith(statementRunner);
                ResultSummary resultSummary = ResultSummaries.process(result.consume());
                return resultSummary;
            }
            catch (RuntimeException e) {
                throw DefaultNeo4jClient.potentiallyConvertRuntimeException(e, DefaultNeo4jClient.this.persistenceExceptionTranslator);
            }
        }

        class DefaultOngoingBindSpec<T>
        implements Neo4jClient.OngoingBindSpec<T, Neo4jClient.RunnableSpecTightToDatabase> {
            @Nullable
            private final T value;

            DefaultOngoingBindSpec(T value) {
                this.value = value;
            }

            @Override
            public Neo4jClient.RunnableSpecTightToDatabase to(String name) {
                DefaultRunnableSpec.this.runnableStatement.parameters.add(name, this.value);
                return DefaultRunnableSpec.this;
            }

            @Override
            public Neo4jClient.RunnableSpecTightToDatabase with(Function<T, Map<String, Object>> binder) {
                Assert.notNull(binder, (String)"Binder is required.");
                return DefaultRunnableSpec.this.bindAll((Map)binder.apply(this.value));
            }
        }
    }

    class RunnableStatement {
        private final Supplier<String> cypherSupplier;
        private final NamedParameters parameters;

        RunnableStatement(Supplier<String> cypherSupplier) {
            this(cypherSupplier, new NamedParameters());
        }

        RunnableStatement(Supplier<String> cypherSupplier, NamedParameters parameters) {
            this.cypherSupplier = cypherSupplier;
            this.parameters = parameters;
        }

        protected final Result runWith(QueryRunner statementRunner) {
            String statementTemplate = this.cypherSupplier.get();
            if (Neo4jClient.cypherLog.isDebugEnabled()) {
                Neo4jClient.cypherLog.debug(() -> String.format("Executing:%s%s", System.lineSeparator(), statementTemplate));
                if (Neo4jClient.cypherLog.isTraceEnabled() && !this.parameters.isEmpty()) {
                    Neo4jClient.cypherLog.trace(() -> String.format("with parameters:%s%s", System.lineSeparator(), this.parameters));
                }
            }
            return statementRunner.run(statementTemplate, this.parameters.get());
        }
    }

    static class DelegatingQueryRunner
    implements QueryRunner,
    AutoCloseable {
        private final QueryRunner delegate;
        private final Collection<Bookmark> usedBookmarks;
        private final BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer;

        private DelegatingQueryRunner(QueryRunner delegate, Collection<Bookmark> lastBookmarks, BiConsumer<Collection<Bookmark>, Bookmark> newBookmarkConsumer) {
            this.delegate = delegate;
            this.usedBookmarks = lastBookmarks;
            this.newBookmarkConsumer = newBookmarkConsumer;
        }

        @Override
        public void close() {
            if (this.delegate instanceof Session) {
                Session session = (Session)this.delegate;
                session.close();
                this.newBookmarkConsumer.accept(this.usedBookmarks, session.lastBookmark());
            }
        }

        public Result run(String s, Value value) {
            return this.delegate.run(s, value);
        }

        public Result run(String s, Map<String, Object> map) {
            return this.delegate.run(s, map);
        }

        public Result run(String s, Record record) {
            return this.delegate.run(s, record);
        }

        public Result run(String s) {
            return this.delegate.run(s);
        }

        public Result run(Query query) {
            return this.delegate.run(query);
        }
    }
}

