/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.event;

import org.apiguardian.api.API;
import org.reactivestreams.Publisher;
import org.springframework.core.Ordered;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.repository.event.IdPopulator;
import org.springframework.data.neo4j.repository.event.ReactiveBeforeBindCallback;
import reactor.core.publisher.Mono;

@API(status=API.Status.INTERNAL, since="6.0")
public final class ReactiveIdGeneratingBeforeBindCallback
implements ReactiveBeforeBindCallback<Object>,
Ordered {
    private final IdPopulator idPopulator;

    public ReactiveIdGeneratingBeforeBindCallback(Neo4jMappingContext neo4jMappingContext) {
        this.idPopulator = new IdPopulator(neo4jMappingContext);
    }

    @Override
    public Publisher<Object> onBeforeBind(Object entity) {
        return Mono.fromSupplier(() -> this.idPopulator.populateIfNecessary(entity));
    }

    public int getOrder() {
        return 110;
    }
}

