/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.driver.Driver;
import org.neo4j.driver.types.TypeSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.AbstractMappingContext;
import org.springframework.data.mapping.model.EntityInstantiator;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.core.convert.ConvertWith;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.convert.Neo4jSimpleTypes;
import org.springframework.data.neo4j.core.mapping.CreateRelationshipStatementHolder;
import org.springframework.data.neo4j.core.mapping.CypherGenerator;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jConversionService;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.MappingSupport;
import org.springframework.data.neo4j.core.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.mapping.NestedRelationshipContext;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionStore;
import org.springframework.data.neo4j.core.mapping.Schema;
import org.springframework.data.neo4j.core.schema.IdGenerator;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.util.ReflectionUtils;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;

@API(status=API.Status.INTERNAL, since="6.0")
public final class Neo4jMappingContext
extends AbstractMappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty>
implements Schema {
    private static final EntityInstantiators INSTANTIATORS = new EntityInstantiators();
    private final Map<Class<? extends IdGenerator<?>>, IdGenerator<?>> idGenerators = new ConcurrentHashMap();
    private final Map<Class<? extends Neo4jPersistentPropertyConverterFactory>, Neo4jPersistentPropertyConverterFactory> converterFactorys = new ConcurrentHashMap<Class<? extends Neo4jPersistentPropertyConverterFactory>, Neo4jPersistentPropertyConverterFactory>();
    private final NodeDescriptionStore nodeDescriptionStore = new NodeDescriptionStore();
    private final Neo4jEntityConverter entityConverter;
    private final Neo4jConversionService conversionService;
    @Nullable
    private AutowireCapableBeanFactory beanFactory;

    public Neo4jMappingContext() {
        this(new Neo4jConversions());
    }

    public Neo4jMappingContext(Neo4jConversions neo4jConversions) {
        this(neo4jConversions, null);
    }

    @API(status=API.Status.INTERNAL, since="6.0")
    public Neo4jMappingContext(Neo4jConversions neo4jConversions, TypeSystem typeSystem) {
        super.setSimpleTypeHolder(Neo4jSimpleTypes.HOLDER);
        this.conversionService = new DefaultNeo4jConversionService(neo4jConversions);
        DefaultNeo4jEntityConverter defaultNeo4jConverter = new DefaultNeo4jEntityConverter(INSTANTIATORS, this.conversionService, this.nodeDescriptionStore);
        if (typeSystem != null) {
            defaultNeo4jConverter.setTypeSystem(typeSystem);
        }
        this.entityConverter = defaultNeo4jConverter;
    }

    @Override
    public Neo4jEntityConverter getEntityConverter() {
        return this.entityConverter;
    }

    public Neo4jConversionService getConversionService() {
        return this.conversionService;
    }

    public EntityInstantiator getInstantiatorFor(PersistentEntity<?, ?> entity) {
        return INSTANTIATORS.getInstantiatorFor(entity);
    }

    boolean hasCustomWriteTarget(Class<?> targetType) {
        return this.conversionService.hasCustomWriteTarget(targetType);
    }

    protected <T> Neo4jPersistentEntity<?> createPersistentEntity(TypeInformation<T> typeInformation) {
        DefaultNeo4jPersistentEntity newEntity = new DefaultNeo4jPersistentEntity(typeInformation);
        String primaryLabel = newEntity.getPrimaryLabel();
        if (this.nodeDescriptionStore.containsKey(primaryLabel)) {
            throw new MappingException(String.format(Locale.ENGLISH, "The schema already contains a node description under the primary label %s", primaryLabel));
        }
        if (this.nodeDescriptionStore.containsValue(newEntity)) {
            Optional<String> label = this.nodeDescriptionStore.entrySet().stream().filter(e -> ((NodeDescription)e.getValue()).equals(newEntity)).map(Map.Entry::getKey).findFirst();
            throw new MappingException(String.format(Locale.ENGLISH, "The schema already contains description %s under the primary label %s", newEntity, label.orElse("n/a")));
        }
        NodeDescription<?> existingDescription = this.getNodeDescription(newEntity.getUnderlyingClass());
        if (existingDescription != null) {
            throw new MappingException(String.format(Locale.ENGLISH, "The schema already contains description with the underlying class %s under the primary label %s", newEntity.getUnderlyingClass().getName(), existingDescription.getPrimaryLabel()));
        }
        this.nodeDescriptionStore.put(primaryLabel, newEntity);
        Class superclass = typeInformation.getType().getSuperclass();
        if (this.isValidParentNode(superclass)) {
            this.addPersistentEntity(superclass).ifPresent(parentNodeDescription -> {
                parentNodeDescription.addChildNodeDescription(newEntity);
                newEntity.setParentNodeDescription((NodeDescription<?>)parentNodeDescription);
            });
        }
        return newEntity;
    }

    private boolean isValidParentNode(@Nullable Class<?> parentClass) {
        if (parentClass == null) {
            return false;
        }
        boolean isExplicitNode = parentClass.isAnnotationPresent(Node.class);
        boolean isAbstractClass = Modifier.isAbstract(parentClass.getModifiers());
        return isExplicitNode && isAbstractClass;
    }

    protected Neo4jPersistentProperty createPersistentProperty(Property property, Neo4jPersistentEntity<?> owner, SimpleTypeHolder simpleTypeHolder) {
        return new DefaultNeo4jPersistentProperty(property, (PersistentEntity<?, Neo4jPersistentProperty>)owner, this, simpleTypeHolder);
    }

    @Override
    @Nullable
    public NodeDescription<?> getNodeDescription(String primaryLabel) {
        return this.nodeDescriptionStore.get(primaryLabel);
    }

    @Override
    public NodeDescription<?> getNodeDescription(Class<?> underlyingClass) {
        return this.nodeDescriptionStore.getNodeDescription(underlyingClass);
    }

    public Optional<Neo4jPersistentEntity<?>> addPersistentEntity(Class<?> type) {
        return super.addPersistentEntity(type);
    }

    private <T> T createBeanOrInstantiate(Class<T> t) {
        Object idGenerator = this.beanFactory == null ? BeanUtils.instantiateClass(t) : this.beanFactory.getBeanProvider(t).getIfUnique(() -> this.beanFactory.createBean(t));
        return (T)idGenerator;
    }

    @Override
    public <T extends IdGenerator<?>> T getOrCreateIdGeneratorOfType(Class<T> idGeneratorType) {
        return (T)this.idGenerators.computeIfAbsent(idGeneratorType, this::createBeanOrInstantiate);
    }

    @Override
    public <T extends IdGenerator<?>> Optional<T> getIdGenerator(String reference) {
        try {
            return Optional.of((IdGenerator)this.beanFactory.getBean(reference));
        }
        catch (NoSuchBeanDefinitionException e) {
            return Optional.empty();
        }
    }

    private <T extends Neo4jPersistentPropertyConverterFactory> T getOrCreateConverterFactoryOfType(Class<T> converterFactoryType) {
        return (T)this.converterFactorys.computeIfAbsent(converterFactoryType, t -> {
            Optional optionalConstructor = ReflectionUtils.findConstructor((Class)t, (Object[])new Object[]{this.conversionService});
            return optionalConstructor.map(c -> (Neo4jPersistentPropertyConverterFactory)BeanUtils.instantiateClass((Constructor)c, (Object[])new Object[]{this.conversionService})).orElseGet(() -> (Neo4jPersistentPropertyConverterFactory)BeanUtils.instantiateClass((Class)t));
        });
    }

    @Nullable
    Neo4jPersistentPropertyConverter getOptionalCustomConversionsFor(Neo4jPersistentProperty persistentProperty) {
        if (!persistentProperty.isAnnotationPresent(ConvertWith.class)) {
            return null;
        }
        ConvertWith convertWith = (ConvertWith)persistentProperty.getRequiredAnnotation(ConvertWith.class);
        Neo4jPersistentPropertyConverterFactory persistentPropertyConverterFactory = this.getOrCreateConverterFactoryOfType(convertWith.converterFactory());
        return persistentPropertyConverterFactory.getPropertyConverterFor(persistentProperty);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        super.setApplicationContext(applicationContext);
        this.beanFactory = applicationContext.getAutowireCapableBeanFactory();
        Driver driver = (Driver)this.beanFactory.getBean(Driver.class);
        ((DefaultNeo4jEntityConverter)this.entityConverter).setTypeSystem(driver.defaultTypeSystem());
    }

    public CreateRelationshipStatementHolder createStatement(Neo4jPersistentEntity<?> neo4jPersistentEntity, NestedRelationshipContext relationshipContext, Long relatedInternalId, Object relatedValue) {
        if (relationshipContext.hasRelationshipWithProperties()) {
            MappingSupport.RelationshipPropertiesWithEntityHolder relatedValueEntityHolder = (MappingSupport.RelationshipPropertiesWithEntityHolder)(relatedValue instanceof MappingSupport.RelationshipPropertiesWithEntityHolder ? relatedValue : (((Map.Entry)relatedValue).getValue() instanceof List ? ((List)((Map.Entry)relatedValue).getValue()).get(0) : ((Map.Entry)relatedValue).getValue()));
            return this.createStatementForRelationShipWithProperties(neo4jPersistentEntity, relationshipContext, relatedInternalId, relatedValueEntityHolder);
        }
        return this.createStatementForRelationshipWithoutProperties(neo4jPersistentEntity, relationshipContext, relatedInternalId, relatedValue);
    }

    private CreateRelationshipStatementHolder createStatementForRelationShipWithProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, NestedRelationshipContext relationshipContext, Long relatedInternalId, MappingSupport.RelationshipPropertiesWithEntityHolder relatedValue) {
        Statement relationshipCreationQuery = CypherGenerator.INSTANCE.createRelationshipWithPropertiesCreationQuery(neo4jPersistentEntity, relationshipContext.getRelationship(), relatedInternalId);
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        this.entityConverter.write(relatedValue.getRelationshipProperties(), propMap);
        return new CreateRelationshipStatementHolder(relationshipCreationQuery, propMap);
    }

    private CreateRelationshipStatementHolder createStatementForRelationshipWithoutProperties(Neo4jPersistentEntity<?> neo4jPersistentEntity, NestedRelationshipContext relationshipContext, Long relatedInternalId, Object relatedValue) {
        String relationshipType;
        if (!relationshipContext.getRelationship().isDynamic()) {
            relationshipType = null;
        } else {
            Neo4jPersistentProperty inverse = relationshipContext.getInverse();
            TypeInformation keyType = inverse.getTypeInformation().getRequiredComponentType();
            Object key = ((Map.Entry)relatedValue).getKey();
            relationshipType = this.conversionService.writeValue(key, keyType, inverse.getOptionalWritingConverter()).asString();
        }
        Statement relationshipCreationQuery = CypherGenerator.INSTANCE.createRelationshipCreationQuery(neo4jPersistentEntity, relationshipContext.getRelationship(), relationshipType, relatedInternalId);
        return new CreateRelationshipStatementHolder(relationshipCreationQuery);
    }
}

