/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.function.Function;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.SortItem;
import org.neo4j.cypherdsl.core.StatementBuilder;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.core.mapping.Constants;
import org.springframework.data.neo4j.core.mapping.GraphPropertyDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescription;

@API(status=API.Status.INTERNAL, since="6.0")
public final class CypherAdapterUtils {
    public static Function<Sort.Order, SortItem> sortAdapterFor(NodeDescription<?> nodeDescription) {
        return order -> {
            String property = nodeDescription.getGraphProperty(order.getProperty()).map(GraphPropertyDescription::getPropertyName).orElseThrow(() -> new IllegalStateException(String.format("Cannot order by the unknown graph property: '%s'", order.getProperty())));
            SortItem sortItem = Cypher.sort((Expression)Cypher.property((Expression)Constants.NAME_OF_ROOT_NODE, (String)property));
            if (order.isDescending()) {
                sortItem = sortItem.descending();
            }
            return sortItem;
        };
    }

    public static SortItem[] toSortItems(NodeDescription<?> nodeDescription, Sort sort) {
        return (SortItem[])sort.stream().map(CypherAdapterUtils.sortAdapterFor(nodeDescription)).toArray(SortItem[]::new);
    }

    public static StatementBuilder.BuildableStatement addPagingParameter(NodeDescription<?> nodeDescription, Pageable pageable, StatementBuilder.OngoingReadingAndReturn returning) {
        Sort sort = pageable.getSort();
        long skip = pageable.getOffset();
        int pageSize = pageable.getPageSize();
        return returning.orderBy(CypherAdapterUtils.toSortItems(nodeDescription, sort)).skip((Number)skip).limit((Number)pageSize);
    }

    private CypherAdapterUtils() {
    }
}

