/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.config;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apiguardian.api.API;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.data.neo4j.core.convert.Neo4jConversions;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

@API(status=API.Status.STABLE, since="6.0")
abstract class Neo4jConfigurationSupport {
    Neo4jConfigurationSupport() {
    }

    @Bean
    public Neo4jConversions neo4jConversions() {
        return new Neo4jConversions();
    }

    @Bean
    public Neo4jMappingContext neo4jMappingContext(Neo4jConversions neo4JConversions) throws ClassNotFoundException {
        Neo4jMappingContext mappingContext = new Neo4jMappingContext(neo4JConversions);
        mappingContext.setInitialEntitySet(this.getInitialEntitySet());
        return mappingContext;
    }

    protected Collection<String> getMappingBasePackages() {
        Package mappingBasePackage = this.getClass().getPackage();
        return Collections.singleton(mappingBasePackage == null ? null : mappingBasePackage.getName());
    }

    protected final Set<Class<?>> getInitialEntitySet() throws ClassNotFoundException {
        HashSet initialEntitySet = new HashSet();
        for (String basePackage : this.getMappingBasePackages()) {
            initialEntitySet.addAll(this.scanForEntities(basePackage));
        }
        return initialEntitySet;
    }

    protected final Set<Class<?>> scanForEntities(String basePackage) throws ClassNotFoundException {
        if (!StringUtils.hasText((String)basePackage)) {
            return Collections.emptySet();
        }
        HashSet initialEntitySet = new HashSet();
        ClassPathScanningCandidateComponentProvider componentProvider = new ClassPathScanningCandidateComponentProvider(false);
        componentProvider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Node.class));
        ClassLoader classLoader = Neo4jConfigurationSupport.class.getClassLoader();
        for (BeanDefinition candidate : componentProvider.findCandidateComponents(basePackage)) {
            initialEntitySet.add(ClassUtils.forName((String)candidate.getBeanClassName(), (ClassLoader)classLoader));
        }
        return initialEntitySet;
    }
}

