/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.filter;

import java.util.Collections;
import java.util.List;
import java.util.Stack;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.neo4j.ogm.cypher.ComparisonOperator;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.function.ContainsAnyComparison;
import org.neo4j.ogm.cypher.function.FilterFunction;
import org.springframework.data.neo4j.repository.query.filter.FilterBuilder;
import org.springframework.data.repository.query.parser.Part;

class ContainsComparisonBuilder
extends FilterBuilder {
    ContainsComparisonBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        super(part, booleanOperator, entityType);
    }

    @Override
    public List<Filter> build(Stack<Object> params) {
        FilterBuilder.NestedAttributes nestedAttributes = this.getNestedAttributes(this.part);
        Object containingValue = params.pop();
        Filter containingFilter = new Filter(nestedAttributes.isEmpty() ? this.propertyName() : nestedAttributes.getLeafPropertySegment(), (FilterFunction)new ContainsAnyComparison(containingValue), ComparisonOperator.IN);
        containingFilter.setOwnerEntityType(this.entityType);
        containingFilter.setBooleanOperator(this.booleanOperator);
        containingFilter.setNegated(this.isNegated());
        containingFilter.setNestedPath(nestedAttributes.getSegments());
        return Collections.singletonList(containingFilter);
    }
}

