/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.conversion;

import java.util.Map;
import org.neo4j.ogm.session.EntityInstantiator;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class Neo4jOgmEntityInstantiatorAdapter
implements EntityInstantiator {
    private final MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context;
    private ConversionService conversionService;
    private final EntityInstantiators instantiators;

    public Neo4jOgmEntityInstantiatorAdapter(MappingContext<Neo4jPersistentEntity<?>, Neo4jPersistentProperty> context, @Nullable ConversionService conversionService) {
        Assert.notNull(context, (String)"MappingContext cannot be null");
        this.context = context;
        this.conversionService = conversionService;
        this.instantiators = new EntityInstantiators();
    }

    public <T> T createInstance(Class<T> clazz, Map<String, Object> propertyValues) {
        Neo4jPersistentEntity persistentEntity = (Neo4jPersistentEntity)this.context.getRequiredPersistentEntity(clazz);
        org.springframework.data.convert.EntityInstantiator instantiator = this.instantiators.getInstantiatorFor((PersistentEntity)persistentEntity);
        return (T)instantiator.createInstance((PersistentEntity)persistentEntity, this.getParameterProvider(propertyValues, this.conversionService));
    }

    private ParameterValueProvider<Neo4jPersistentProperty> getParameterProvider(Map<String, Object> propertyValues, ConversionService conversionService) {
        return new Neo4jPropertyValueProvider(propertyValues, conversionService);
    }

    private static class Neo4jPropertyValueProvider
    implements ParameterValueProvider<Neo4jPersistentProperty> {
        private Map<String, Object> propertyValues;
        private ConversionService conversionService;

        Neo4jPropertyValueProvider(Map<String, Object> propertyValues, ConversionService conversionService) {
            this.conversionService = conversionService;
            Assert.notNull(propertyValues, (String)"Properties cannot be null");
            this.propertyValues = propertyValues;
        }

        @Nullable
        public Object getParameterValue(PreferredConstructor.Parameter parameter) {
            Object value = this.propertyValues.get(parameter.getName());
            if (value == null || this.conversionService == null) {
                return value;
            }
            return this.conversionService.convert(value, parameter.getType().getType());
        }
    }
}

