/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.cdi;

import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.support.Neo4jRepositoryFactory;
import org.springframework.data.repository.cdi.CdiRepositoryBean;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;

public class Neo4jCdiRepositoryBean<T>
extends CdiRepositoryBean<T> {
    private final Bean<Session> sessionBean;

    public Neo4jCdiRepositoryBean(Bean<Session> sessionBean, Set<Annotation> qualifiers, Class<T> repositoryType, BeanManager beanManager, Optional<CustomRepositoryImplementationDetector> detector) {
        super(qualifiers, repositoryType, beanManager, detector);
        this.sessionBean = sessionBean;
    }

    protected T create(CreationalContext<T> creationalContext, Class<T> repositoryType, Optional<Object> customImplementation) {
        Session session = (Session)this.getDependencyInstance(this.sessionBean, Session.class);
        Neo4jRepositoryFactory factory = new Neo4jRepositoryFactory(session);
        return (T)customImplementation.map(impl -> factory.getRepository(repositoryType, impl)).orElseGet(() -> factory.getRepository(repositoryType));
    }
}

