/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.context.SingleUseEntityMapper;
import org.neo4j.ogm.entity.io.EntityFactory;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.request.Request;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.transaction.Transaction;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.neo4j.repository.query.GraphRepositoryQuery;
import org.springframework.data.neo4j.repository.query.QueryResultProxy;
import org.springframework.data.repository.query.ParameterAccessor;

public class QueryResultGraphRepositoryQuery
extends GraphRepositoryQuery {
    public QueryResultGraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        super(graphQueryMethod, session);
    }

    @Override
    protected Object execute(Class<?> returnType, Class<?> concreteReturnType, String cypherQuery, Map<String, Object> queryParams, ParameterAccessor parameterAccessor) {
        Object resultObjects;
        Pageable pageable = parameterAccessor.getPageable();
        Sort sort = parameterAccessor.getSort();
        if (pageable != null && pageable.getSort() != null) {
            sort = pageable.getSort();
        }
        if (sort != null) {
            cypherQuery = this.addSorting(cypherQuery, sort);
        }
        Object object = resultObjects = concreteReturnType.isInterface() ? this.mapToProxy(concreteReturnType, cypherQuery, queryParams, pageable) : this.mapToConcreteType(concreteReturnType, cypherQuery, queryParams, pageable);
        if (Iterable.class.isAssignableFrom(returnType)) {
            return resultObjects;
        }
        Collection objects = (Collection)resultObjects;
        return objects.isEmpty() ? null : objects.iterator().next();
    }

    private Object mapToConcreteType(Class<?> targetType, String cypherQuery, Map<String, Object> queryParams, Pageable pageable) {
        if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
            String query = this.addPaging(cypherQuery, queryParams, pageable.getPageNumber(), pageable.getPageSize());
            List resultList = this.mappedConcreteResults(targetType, query, queryParams);
            return this.createPage(this.graphQueryMethod, resultList, pageable, this.computeCount(queryParams));
        }
        return this.mappedConcreteResults(targetType, cypherQuery, queryParams);
    }

    private Object mapToProxy(Class<?> targetType, String cypherQuery, Map<String, Object> queryParams, Pageable pageable) {
        if (this.graphQueryMethod.isPageQuery() || this.graphQueryMethod.isSliceQuery()) {
            String query = this.addPaging(cypherQuery, queryParams, pageable.getPageNumber(), pageable.getPageSize());
            List objects = this.mappedProxyResults(targetType, (Iterable<Map<String, Object>>)this.session.query(query, queryParams));
            return this.createPage(this.graphQueryMethod, objects, pageable, this.computeCount(queryParams));
        }
        return this.mappedProxyResults(targetType, (Iterable<Map<String, Object>>)this.session.query(cypherQuery, queryParams));
    }

    private List mappedConcreteResults(final Class<?> targetType, final String query, final Map<String, Object> queryParams) {
        return (List)this.session.doInTransaction((GraphCallback)new GraphCallback<Collection<Object>>(){

            public Collection<Object> apply(Request requestHandler, Transaction transaction, MetaData metaData) {
                ArrayList<Object> toReturn = new ArrayList<Object>();
                SingleUseEntityMapper entityMapper = new SingleUseEntityMapper(metaData, new EntityFactory(metaData));
                Result results = QueryResultGraphRepositoryQuery.this.session.query(query, queryParams);
                for (Map result : results) {
                    toReturn.add(entityMapper.map(targetType, result));
                }
                return toReturn;
            }
        });
    }

    private List mappedProxyResults(Class<?> targetType, Iterable<Map<String, Object>> queryResults) {
        ArrayList<Object> resultObjects = new ArrayList<Object>();
        Class[] interfaces = new Class[]{targetType};
        for (Map<String, Object> map : queryResults) {
            resultObjects.add(Proxy.newProxyInstance(targetType.getClassLoader(), interfaces, (InvocationHandler)new QueryResultProxy(map)));
        }
        return resultObjects;
    }
}

