/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query.derived.builder;

import java.util.List;
import org.neo4j.ogm.cypher.BooleanOperator;
import org.springframework.data.neo4j.repository.query.derived.CypherFilter;
import org.springframework.data.repository.query.parser.Part;

public abstract class CypherFilterBuilder {
    protected Part part;
    protected BooleanOperator booleanOperator;
    protected Class<?> entityType;

    public CypherFilterBuilder(Part part, BooleanOperator booleanOperator, Class<?> entityType) {
        this.part = part;
        this.booleanOperator = booleanOperator;
        this.entityType = entityType;
    }

    public abstract List<CypherFilter> build();

    protected boolean isNegated() {
        return this.part.getType().name().startsWith("NOT");
    }

    protected String propertyName() {
        return this.part.getProperty().getSegment();
    }

    protected void setNestedAttributes(Part part, CypherFilter filter) {
        if (part.getProperty().next() != null) {
            filter.setOwnerEntityType(part.getProperty().getOwningType().getType());
            filter.setNestedPropertyType(part.getProperty().getType());
            filter.setPropertyName(part.getProperty().getLeafProperty().getSegment());
            filter.setNestedPropertyName(part.getProperty().getSegment());
        }
    }
}

