/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.model.QueryStatistics;
import org.neo4j.ogm.model.Result;
import org.neo4j.ogm.session.Session;
import org.springframework.data.neo4j.repository.query.GraphQueryMethod;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;

public class GraphRepositoryQuery
implements RepositoryQuery {
    private final GraphQueryMethod graphQueryMethod;
    protected final Session session;

    public GraphRepositoryQuery(GraphQueryMethod graphQueryMethod, Session session) {
        this.graphQueryMethod = graphQueryMethod;
        this.session = session;
    }

    public final Object execute(Object[] parameters) {
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        Class<?> concreteType = this.graphQueryMethod.resolveConcreteReturnType();
        Map<String, Object> params = this.resolveParams(parameters);
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.graphQueryMethod.getParameters(), parameters);
        ResultProcessor processor = this.graphQueryMethod.getResultProcessor();
        Object result = this.execute(returnType, concreteType, this.getQueryString(), params);
        return Result.class.equals(returnType) ? result : processor.withDynamicProjection((ParameterAccessor)accessor).processResult(result);
    }

    protected Object execute(Class<?> returnType, Class<?> concreteType, String cypherQuery, Map<String, Object> queryParams) {
        if (returnType.equals(Void.class) || returnType.equals(Void.TYPE)) {
            this.session.query(cypherQuery, queryParams);
            return null;
        }
        if (Iterable.class.isAssignableFrom(returnType) && !this.queryReturnsStatistics()) {
            if (Map.class.isAssignableFrom(concreteType)) {
                return this.session.query(cypherQuery, queryParams).queryResults();
            }
            return this.session.query(concreteType, cypherQuery, queryParams);
        }
        if (this.queryReturnsStatistics()) {
            return this.session.query(cypherQuery, queryParams);
        }
        return this.session.queryForObject(returnType, cypherQuery, queryParams);
    }

    private Map<String, Object> resolveParams(Object[] parameters) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameters methodParameters = this.graphQueryMethod.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = methodParameters.getParameter(i);
            Object parameterValue = this.session.resolveGraphIdFor(parameters[i]);
            if (parameterValue == null) {
                parameterValue = parameters[i];
            }
            if (parameter.isNamedParameter()) {
                params.put(parameter.getName(), parameterValue);
                continue;
            }
            params.put("" + i, parameterValue);
        }
        return params;
    }

    public GraphQueryMethod getQueryMethod() {
        return this.graphQueryMethod;
    }

    protected String getQueryString() {
        return this.getQueryMethod().getQuery();
    }

    private boolean queryReturnsStatistics() {
        Class<?> returnType = this.graphQueryMethod.getMethod().getReturnType();
        return QueryStatistics.class.isAssignableFrom(returnType) || Result.class.isAssignableFrom(returnType);
    }
}

