/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.core.convert.ConversionException;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;

public class GeoConverter {
    public static final Pattern WKT_POINT = Pattern.compile("^POINT *\\( *([+-]?[\\d.]+) *([+-]?[\\d.]+) *\\) *$", 2);
    private static final String POINT = " *[+-]?[\\d.]+ *[+-]?[\\d.]+ *";
    public static final Pattern WKT_POLYGON = Pattern.compile("^POLYGON *\\( *\\(((?: *[+-]?[\\d.]+ *[+-]?[\\d.]+ *,)* *[+-]?[\\d.]+ *[+-]?[\\d.]+ *) *\\) *\\) *$", 2);

    public static String toWktCoords(Point point) {
        return String.format(Locale.ENGLISH, "%s %s", point.getX(), point.getY());
    }

    public static String toWkt(Polygon shape) {
        StringBuilder wkt = new StringBuilder("POLYGON((");
        List points = shape.getPoints();
        if (!points.isEmpty()) {
            for (Point point : points) {
                wkt.append(GeoConverter.toWktCoords(point)).append(",");
            }
            wkt.append(GeoConverter.toWktCoords((Point)points.get(0)));
        }
        wkt.append("))");
        return wkt.toString();
    }

    public static String toWellKnownText(Point point) throws ConversionException {
        return "POINT(" + GeoConverter.toWktCoords(point) + ")";
    }

    public static String toWellKnownText(Shape shape) throws ConversionException {
        if (shape instanceof Point) {
            return "POINT(" + GeoConverter.toWktCoords((Point)shape) + ")";
        }
        if (shape instanceof Polygon) {
            return GeoConverter.toWkt((Polygon)shape);
        }
        if (shape instanceof Circle) {
            return GeoConverter.toWkt(GeoConverter.toPolygon((Circle)shape, 12));
        }
        if (shape instanceof Box) {
            return GeoConverter.toWkt(GeoConverter.toPolygon((Box)shape));
        }
        throw new RuntimeException("Could not convert shape to WKT " + shape);
    }

    public static Polygon toPolygon(Circle circle, int segments) {
        float angle = 0.0f;
        float delta = (float)Math.PI * 2 / (float)segments;
        Point center = circle.getCenter();
        double milesPerDegree = 69.0;
        double verticalRadius = circle.getRadius().in((Metric)Metrics.MILES).getValue() / milesPerDegree;
        double horizontalModifier = Math.abs(Math.cos(Math.toRadians(center.getY())));
        double horizontalRadius = verticalRadius / horizontalModifier;
        ArrayList<Point> points = new ArrayList<Point>(segments);
        for (int i = 0; i < segments; ++i) {
            points.add(new Point(Math.cos(angle) * horizontalRadius + center.getX(), Math.sin(angle) * verticalRadius + center.getY()));
            angle += delta;
        }
        return new Polygon(points);
    }

    public static Polygon toPolygon(Box box) {
        Point first = box.getFirst();
        Point second = box.getSecond();
        return new Polygon(new Point(first.getX(), first.getY()), new Point(second.getX(), first.getY()), new Point(second.getX(), second.getY()), new Point[]{new Point(first.getX(), second.getY())});
    }

    public static Polygon fromWellKnownText(String wkt) {
        Matcher matcher = WKT_POLYGON.matcher(wkt);
        if (matcher.matches()) {
            String[] pointStrings = matcher.group(1).split(" *, *");
            ArrayList<Point> points = new ArrayList<Point>(pointStrings.length);
            for (String pointString : pointStrings) {
                String[] coords = pointString.trim().split(" +");
                Point point = new Point(Double.parseDouble(coords[0]), Double.parseDouble(coords[1]));
                if (points.contains(point)) continue;
                points.add(point);
            }
            return new Polygon(points);
        }
        throw new RuntimeException("Error parsing '" + wkt + "' as POINT(x y) well known text");
    }

    public static Point pointFromWellKnownText(String wkt) {
        Matcher matcher = WKT_POINT.matcher(wkt);
        if (matcher.matches()) {
            return new Point(Double.parseDouble(matcher.group(1)), Double.parseDouble(matcher.group(2)));
        }
        throw new RuntimeException("Error parsing '" + wkt + "' as POINT(x y) well known text");
    }
}

