/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import java.util.Arrays;
import java.util.Map;
import org.json.simple.JSONArray;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.collection.MapUtil;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Metrics;
import org.springframework.data.geo.Point;
import org.springframework.data.geo.Polygon;
import org.springframework.data.geo.Shape;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.repository.GeoConverter;
import org.springframework.data.neo4j.repository.LegacyIndexSearcher;
import org.springframework.data.neo4j.repository.SpatialRepository;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

public class GeoQueries<S extends PropertyContainer, T>
implements SpatialRepository<T> {
    public static final String WITHIN_WKT_GEOMETRY = "withinWKTGeometry";
    public static final String WITHIN_DISTANCE = "withinDistance";
    public static final String BBOX = "bbox";
    private final LegacyIndexSearcher<S, T> legacyIndexSearcher;

    public GeoQueries(LegacyIndexSearcher<S, T> legacyIndexSearcher) {
        this.legacyIndexSearcher = legacyIndexSearcher;
    }

    @Override
    public Result<T> findWithinWellKnownText(String indexName, String wellKnownText) {
        return this.legacyIndexSearcher.geoQuery(indexName, WITHIN_WKT_GEOMETRY, wellKnownText);
    }

    @Override
    public Result<T> findWithinShape(String indexName, Shape shape) {
        Assert.notNull((Object)indexName, (String)"geo-index-name must not be null");
        Assert.notNull((Object)shape, (String)"shape must not be null");
        if (shape instanceof Circle) {
            return this.findWithinDistance(indexName, (Circle)shape);
        }
        if (shape instanceof Box) {
            return this.findWithinBoundingBox(indexName, (Box)shape);
        }
        if (shape instanceof Polygon) {
            return this.findWithinWellKnownText(indexName, GeoConverter.toWkt((Polygon)shape));
        }
        throw new InvalidDataAccessApiUsageException("Unknown shape " + shape.getClass().getSimpleName() + " " + shape);
    }

    @Override
    public Result<T> findWithinDistance(String indexName, double lat, double lon, double distanceKm) {
        return this.legacyIndexSearcher.geoQuery(indexName, WITHIN_DISTANCE, GeoQueries.toWithinDistanceParams(lat, lon, distanceKm));
    }

    private static Map<String, Object> toWithinDistanceParams(double lat, double lon, double distanceKm) {
        return MapUtil.map((Object[])new Object[]{"point", new Double[]{lat, lon}, "distanceInKm", distanceKm});
    }

    @Override
    public Result<T> findWithinDistance(String indexName, Circle circle) {
        return this.legacyIndexSearcher.geoQuery(indexName, WITHIN_DISTANCE, GeoQueries.toWithinDistanceParams(circle));
    }

    private static Map<String, Object> toWithinDistanceParams(Circle circle) {
        double distance = circle.getRadius().in((Metric)Metrics.KILOMETERS).getValue();
        return GeoQueries.toWithinDistanceParams(circle.getCenter().getY(), circle.getCenter().getX(), distance);
    }

    private static String toWithinDistanceParamsString(Circle circle) {
        double distance = circle.getRadius().in((Metric)Metrics.KILOMETERS).getValue();
        return JSONArray.toJSONString(Arrays.asList(circle.getCenter().getY(), circle.getCenter().getX(), distance));
    }

    @Override
    public Result<T> findWithinBoundingBox(String indexName, double lowerLeftLat, double lowerLeftLon, double upperRightLat, double upperRightLon) {
        return this.legacyIndexSearcher.geoQuery(indexName, BBOX, GeoQueries.toBoundingBoxParams(lowerLeftLat, lowerLeftLon, upperRightLat, upperRightLon));
    }

    private static String toBoundingBoxParams(double lowerLeftLat, double lowerLeftLon, double upperRightLat, double upperRightLon) {
        return JSONArray.toJSONString(Arrays.asList(lowerLeftLon, upperRightLon, lowerLeftLat, upperRightLat));
    }

    @Override
    public Result<T> findWithinBoundingBox(String indexName, Box box) {
        return this.legacyIndexSearcher.geoQuery(indexName, BBOX, GeoQueries.toBoundingBoxParams(box));
    }

    private static String toBoundingBoxParams(Box box) {
        Point first = box.getFirst();
        Point second = box.getSecond();
        return GeoQueries.toBoundingBoxParams(Math.min(first.getY(), second.getY()), Math.min(first.getX(), second.getX()), Math.max(first.getY(), second.getY()), Math.max(first.getX(), second.getX()));
    }

    public static Pair<String, String> toQueryParams(Part.Type type, Object value) {
        if (value instanceof String && type == Part.Type.WITHIN) {
            return Pair.of((Object)WITHIN_WKT_GEOMETRY, (Object)((String)value));
        }
        if (value instanceof Circle && (type == Part.Type.NEAR || type == Part.Type.WITHIN)) {
            return Pair.of((Object)WITHIN_DISTANCE, (Object)GeoQueries.toWithinDistanceParamsString((Circle)value));
        }
        if (value instanceof Box && type == Part.Type.WITHIN) {
            return Pair.of((Object)BBOX, (Object)GeoQueries.toBoundingBoxParams((Box)value));
        }
        if (value instanceof Polygon && type == Part.Type.WITHIN) {
            return Pair.of((Object)WITHIN_WKT_GEOMETRY, (Object)GeoConverter.toWkt((Polygon)value));
        }
        throw new IllegalArgumentException(String.format("Must have a geospatial operator like equals, within or inside, but has %s and must have a geospatial value like circle, box, polygon, or WKT-String but has %s %s", type, value == null ? null : value.getClass(), value));
    }
}

