/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.Arrays;
import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.support.mapping.HierarchicalTypeInformationMapper;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.SourceStateTransmitter;
import org.springframework.data.neo4j.support.mapping.TRSTypeAliasAccessor;
import org.springframework.data.neo4j.support.node.EntityStateFactory;

public class EntityTools<S extends PropertyContainer> {
    private TypeRepresentationStrategy<S> typeRepresentationStrategy;
    private EntityStateFactory<S> entityStateFactory;
    private EntityInstantiator<S> entityInstantiator;
    private SourceStateTransmitter<S> sourceStateTransmitter;
    private TypeMapper<S> typeMapper;

    public EntityTools(TypeRepresentationStrategy<S> typeRepresentationStrategy, EntityStateFactory<S> entityStateFactory, EntityInstantiator<S> entityInstantiator, Neo4jMappingContext ctx) {
        this.typeRepresentationStrategy = typeRepresentationStrategy;
        this.entityStateFactory = entityStateFactory;
        this.entityInstantiator = entityInstantiator;
        this.sourceStateTransmitter = new SourceStateTransmitter<S>(entityStateFactory);
        this.typeMapper = new DefaultTypeMapper(new TRSTypeAliasAccessor<S>(typeRepresentationStrategy), Arrays.asList(new HierarchicalTypeInformationMapper(ctx)));
    }

    public TypeRepresentationStrategy<S> getTypeRepresentationStrategy() {
        return this.typeRepresentationStrategy;
    }

    public EntityStateFactory<S> getEntityStateFactory() {
        return this.entityStateFactory;
    }

    public EntityInstantiator<S> getEntityInstantiator() {
        return this.entityInstantiator;
    }

    public SourceStateTransmitter<S> getSourceStateTransmitter() {
        return this.sourceStateTransmitter;
    }

    public TypeMapper<S> getTypeMapper() {
        return this.typeMapper;
    }
}

