/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.Query;
import org.springframework.data.neo4j.conversion.Result;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.DoReturn;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.query.CypherQueryEngine;
import org.springframework.data.util.TypeInformation;

public class QueryFieldAccessorFactory
implements FieldAccessorFactory {
    private final Neo4jTemplate template;

    public QueryFieldAccessorFactory(Neo4jTemplate template) {
        this.template = template;
    }

    @Override
    public boolean accept(Neo4jPersistentProperty property) {
        return property.hasQuery();
    }

    @Override
    public FieldAccessor forField(Neo4jPersistentProperty property) {
        return new QueryFieldAccessor(property, this.template);
    }

    public static class QueryFieldAccessor
    implements FieldAccessor {
        protected final Neo4jPersistentProperty property;
        private final Neo4jTemplate template;
        private final String query;
        private Class<?> target;
        protected String[] annotationParams;
        private boolean iterableResult;
        private final CypherQueryEngine queryEngine;

        public QueryFieldAccessor(Neo4jPersistentProperty property, Neo4jTemplate template) {
            this.property = property;
            this.template = template;
            Query query = property.getAnnotation(Query.class);
            this.annotationParams = query.params();
            if (this.annotationParams.length % 2 != 0) {
                throw new IllegalArgumentException("Number of parameters has to be even to construct a parameter map");
            }
            this.query = property.getQuery();
            this.iterableResult = Iterable.class.isAssignableFrom(property.getType());
            this.target = this.resolveTarget(query, property);
            this.queryEngine = this.template.queryEngineFor();
        }

        private Class<?> resolveTarget(Query query, Neo4jPersistentProperty property) {
            if (!query.elementClass().equals(Object.class)) {
                return query.elementClass();
            }
            return property.getTypeInformation().getActualType().getType();
        }

        @Override
        public boolean isWriteable(Object entity) {
            return false;
        }

        @Override
        public Object setValue(Object entity, Object newVal, MappingPolicy mappingPolicy) {
            throw new InvalidDataAccessApiUsageException("Cannot set readonly query field " + this.property);
        }

        @Override
        public Object getValue(Object entity, MappingPolicy mappingPolicy) {
            return DoReturn.doReturn(this.executeQuery(entity, this.query, this.createPlaceholderParams(entity), mappingPolicy));
        }

        private Object executeQuery(Object entity, String queryString, Map<String, Object> params, MappingPolicy mappingPolicy) {
            TypeInformation typeInformation = this.property.getTypeInformation();
            TypeInformation actualType = typeInformation.getActualType();
            Class targetType = actualType.getType();
            Result result = this.queryEngine.query(queryString, params).with(mappingPolicy);
            if (actualType.isMap()) {
                return result;
            }
            if (typeInformation.isCollectionLike()) {
                return result.to(targetType);
            }
            return result.to(targetType).singleOrNull();
        }

        private Map<String, Object> createPlaceholderParams(Object entity) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            Node startNode = (Node)this.template.getPersistentState(entity);
            params.put("self", startNode.getId());
            if (this.annotationParams.length == 0) {
                return params;
            }
            for (int i = 0; i < this.annotationParams.length; i += 2) {
                params.put(this.annotationParams[i], this.annotationParams[i + 1]);
            }
            return params;
        }

        @Override
        public Object getDefaultValue() {
            return null;
        }
    }
}

