/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.typerepresentation;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.ClosableIterable;
import org.neo4j.helpers.collection.IterableWrapper;
import org.neo4j.kernel.Traversal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.core.GraphDatabase;
import org.springframework.data.neo4j.core.NodeTypeRepresentationStrategy;
import org.springframework.data.neo4j.support.ReferenceNodes;
import org.springframework.data.neo4j.support.mapping.StoredEntityType;
import org.springframework.data.neo4j.support.typerepresentation.ClosableCombiningIterable;
import org.springframework.data.neo4j.support.typerepresentation.EntityTypeCache;

public class SubReferenceNodeTypeRepresentationStrategy
implements NodeTypeRepresentationStrategy {
    private static final Logger log = LoggerFactory.getLogger(SubReferenceNodeTypeRepresentationStrategy.class);
    public static final RelationshipType INSTANCE_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"INSTANCE_OF");
    public static final RelationshipType SUBCLASS_OF_RELATIONSHIP_TYPE = DynamicRelationshipType.withName((String)"SUBCLASS_OF");
    public static final String SUBREFERENCE_NODE_COUNTER_KEY = "count";
    public static final String SUBREF_PREFIX = "SUBREF_";
    public static final String SUBREF_CLASS_KEY = "class";
    private long referenceNodeId;
    private GraphDatabase graphDatabase;
    private final EntityTypeCache typeCache;

    public SubReferenceNodeTypeRepresentationStrategy(GraphDatabase graphDatabase) {
        this.graphDatabase = graphDatabase;
        this.referenceNodeId = ReferenceNodes.obtainReferenceNode(graphDatabase, "root").getId();
        this.typeCache = new EntityTypeCache();
    }

    public static Node getSingleOtherNode(Node node, RelationshipType type, Direction direction) {
        Relationship rel = node.getSingleRelationship(type, direction);
        return rel == null ? null : rel.getOtherNode(node);
    }

    public static Integer incrementAndGetCounter(Node node, String propertyKey) {
        SubReferenceNodeTypeRepresentationStrategy.acquireWriteLock((PropertyContainer)node);
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        node.setProperty(propertyKey, (Object)(++value));
        return value;
    }

    public static Integer decrementAndGetCounter(Node node, String propertyKey, int notLowerThan) {
        int value = (Integer)node.getProperty(propertyKey, (Object)0);
        value = --value < notLowerThan ? notLowerThan : value;
        node.setProperty(propertyKey, (Object)value);
        return value;
    }

    public static void acquireWriteLock(PropertyContainer entity) {
        entity.removeProperty("___dummy_property_for_locking___");
    }

    public static boolean isStrategyAlreadyInUse(GraphDatabase graphDatabaseService) {
        try {
            Node referenceNode = ReferenceNodes.getReferenceNode(graphDatabaseService, "root");
            if (referenceNode == null) {
                return false;
            }
            for (Relationship rel : referenceNode.getRelationships()) {
                if (!rel.getType().name().startsWith(SUBREF_PREFIX)) continue;
                return true;
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void writeTypeTo(Node state, StoredEntityType type) {
        Node subReference = this.obtainSubreferenceNode(type);
        for (Relationship relationship : state.getRelationships(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING)) {
            if (!relationship.getEndNode().equals(subReference)) continue;
            return;
        }
        state.createRelationshipTo(subReference, INSTANCE_OF_RELATIONSHIP_TYPE);
        subReference.setProperty(SUBREF_CLASS_KEY, type.getAlias());
        if (log.isDebugEnabled()) {
            log.debug("Created link to subref node: " + subReference + " with type: " + type.getType().getSimpleName() + " alias " + type.getAlias());
        }
        SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(subReference, SUBREFERENCE_NODE_COUNTER_KEY);
        for (StoredEntityType superType : type.getSuperTypes()) {
            this.updateSuperClassSubrefs(superType, subReference);
        }
    }

    private void updateSuperClassSubrefs(StoredEntityType type, Node subReference) {
        if (type == null || !type.isNodeEntity()) {
            return;
        }
        Node superClassSubref = this.obtainSubreferenceNode(type);
        if (SubReferenceNodeTypeRepresentationStrategy.getSingleOtherNode(subReference, SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING) == null) {
            subReference.createRelationshipTo(superClassSubref, SUBCLASS_OF_RELATIONSHIP_TYPE);
        }
        superClassSubref.setProperty(SUBREF_CLASS_KEY, type.getAlias());
        Integer count = SubReferenceNodeTypeRepresentationStrategy.incrementAndGetCounter(superClassSubref, SUBREFERENCE_NODE_COUNTER_KEY);
        if (log.isDebugEnabled()) {
            log.debug("count on ref " + superClassSubref + " for class " + type.getType().getSimpleName() + " alias: " + type.getAlias() + " = " + count);
        }
        for (StoredEntityType superType : type.getSuperTypes()) {
            this.updateSuperClassSubrefs(superType, subReference);
        }
    }

    @Override
    public long count(StoredEntityType type) {
        Node subrefNode = this.findSubreferenceNode(type);
        if (subrefNode == null) {
            return 0L;
        }
        return ((Integer)subrefNode.getProperty(SUBREFERENCE_NODE_COUNTER_KEY, (Object)0)).intValue();
    }

    @Override
    public Object readAliasFrom(Node node) {
        if (node == null) {
            throw new IllegalArgumentException("Node is null");
        }
        Relationship instanceOfRelationship = node.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        if (instanceOfRelationship == null) {
            throw new IllegalArgumentException("The node " + node + " is not attached to a type hierarchy.");
        }
        Node subrefNode = instanceOfRelationship.getEndNode();
        Object typeAlias = subrefNode.getProperty(SUBREF_CLASS_KEY);
        if (log.isDebugEnabled()) {
            log.debug("Found alias " + typeAlias + " for node: " + node);
        }
        return typeAlias;
    }

    @Override
    public void preEntityRemoval(Node state) {
        Object alias = this.readAliasFrom(state);
        if (alias == null) {
            return;
        }
        Node subReference = this.obtainSubreferenceNode(alias);
        Relationship instanceOf = state.getSingleRelationship(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        instanceOf.delete();
        if (log.isDebugEnabled()) {
            log.debug("Removed link to subref node: " + subReference + " with alias: " + alias);
        }
        TraversalDescription traversal = Traversal.description().depthFirst().relationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.OUTGOING);
        for (Node node : traversal.traverse(subReference).nodes()) {
            Integer count = (Integer)node.getProperty(SUBREFERENCE_NODE_COUNTER_KEY);
            Integer newCount = SubReferenceNodeTypeRepresentationStrategy.decrementAndGetCounter(node, SUBREFERENCE_NODE_COUNTER_KEY, 0);
            if (!log.isDebugEnabled()) continue;
            log.debug("count on ref " + node + " was " + count + " new " + newCount);
        }
    }

    @Override
    public boolean isLabelBased() {
        return false;
    }

    @Override
    public <T> ClosableIterable<Node> findAll(StoredEntityType type) {
        Node subrefNode = this.findSubreferenceNode(type);
        if (log.isDebugEnabled()) {
            log.debug("Subref: " + subrefNode);
        }
        List relIterables = this.findEntityIterables(subrefNode);
        return new ClosableCombiningIterable<Node>(relIterables);
    }

    private List<Iterable<Node>> findEntityIterables(Node subrefNode) {
        if (subrefNode == null) {
            return Collections.emptyList();
        }
        LinkedList<Iterable<Node>> result = new LinkedList<Iterable<Node>>();
        for (Relationship relationship : subrefNode.getRelationships(SUBCLASS_OF_RELATIONSHIP_TYPE, Direction.INCOMING)) {
            List<Iterable<Node>> entityIterables = this.findEntityIterables(relationship.getStartNode());
            result.addAll(entityIterables);
        }
        IterableWrapper<Node, Relationship> t = new IterableWrapper<Node, Relationship>(subrefNode.getRelationships(INSTANCE_OF_RELATIONSHIP_TYPE, Direction.INCOMING)){

            protected Node underlyingObjectToObject(Relationship rel) {
                return rel.getStartNode();
            }
        };
        result.add((Iterable<Node>)t);
        return result;
    }

    public Node obtainSubreferenceNode(StoredEntityType type) {
        return this.getOrCreateSubReferenceNode((RelationshipType)this.subRefRelationshipType(type));
    }

    public Node obtainSubreferenceNode(Object alias) {
        return this.getOrCreateSubReferenceNode((RelationshipType)this.subRefRelationshipType(alias));
    }

    public Node findSubreferenceNode(StoredEntityType type) {
        return this.findSubreferenceNode(type.getAlias());
    }

    public Node findSubreferenceNode(Object alias) {
        Relationship subrefRelationship = this.referenceNode().getSingleRelationship((RelationshipType)this.subRefRelationshipType(alias), Direction.OUTGOING);
        return subrefRelationship != null ? subrefRelationship.getEndNode() : null;
    }

    private DynamicRelationshipType subRefRelationshipType(Object alias) {
        return DynamicRelationshipType.withName((String)(SUBREF_PREFIX + alias));
    }

    private DynamicRelationshipType subRefRelationshipType(StoredEntityType type) {
        return this.subRefRelationshipType(type.getAlias());
    }

    public Node getOrCreateSubReferenceNode(RelationshipType relType) {
        return this.getOrCreateSingleOtherNode(this.referenceNode(), relType, Direction.OUTGOING);
    }

    private Node referenceNode() {
        try {
            return this.graphDatabase.getNodeById(this.referenceNodeId);
        }
        catch (NotFoundException nfe) {
            Node node = ReferenceNodes.obtainReferenceNode(this.graphDatabase, "root");
            this.referenceNodeId = node.getId();
            return node;
        }
    }

    private Node getOrCreateSingleOtherNode(Node fromNode, RelationshipType type, Direction direction) {
        Relationship singleRelationship = fromNode.getSingleRelationship(type, direction);
        if (singleRelationship != null) {
            return singleRelationship.getOtherNode(fromNode);
        }
        Node otherNode = this.graphDatabase.createNode(null);
        if (direction == Direction.OUTGOING) {
            fromNode.createRelationshipTo(otherNode, type);
        } else {
            otherNode.createRelationshipTo(fromNode, type);
        }
        return otherNode;
    }
}

