/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import org.springframework.data.neo4j.support.index.IndexType;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.TYPE, ElementType.METHOD})
public @interface Indexed {
    public String indexName() default "";

    public IndexType indexType() default IndexType.LABEL;

    public String fieldName() default "";

    public boolean unique() default false;

    public boolean numeric() default false;

    public Level level() default Level.CLASS;

    public static enum Level {
        GLOBAL,
        CLASS,
        INSTANCE;

    }

    public static class Name {
        public static String getDefault(Field field) {
            return Name.get(field.getDeclaringClass());
        }

        public static String get(Class<?> type) {
            return Name.getIndexName(type, type.getSimpleName());
        }

        private static String getIndexName(AnnotatedElement element, String defaultIndexName) {
            Indexed indexed = element.getAnnotation(Indexed.class);
            if (indexed == null || indexed.indexName() == null || indexed.indexName().isEmpty()) {
                return defaultIndexName;
            }
            return indexed.indexName();
        }

        public static String get(Field field) {
            return Name.getIndexName(field, Name.getDefault(field));
        }

        public static String get(Level level, Class<?> type, String providedIndexName, Class<?> instanceType) {
            if (providedIndexName != null) {
                return providedIndexName;
            }
            switch (level) {
                case GLOBAL: {
                    return "nodes";
                }
                case CLASS: {
                    return Name.get(type);
                }
                case INSTANCE: {
                    return Name.get(instanceType);
                }
            }
            return Name.get(type);
        }
    }
}

