/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.springframework.data.neo4j.fieldaccess.DynamicProperties;

public class PrefixedDynamicProperties
implements DynamicProperties,
Serializable {
    private static final long serialVersionUID = 1L;
    private final transient Map<String, Object> map;
    protected final transient String prefix;

    private Object writeReplace() {
        return new SerializationProxy(this);
    }

    private void readObject(ObjectInputStream ois) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    public PrefixedDynamicProperties(String prefix) {
        this.map = new HashMap<String, Object>();
        this.prefix = prefix;
    }

    public PrefixedDynamicProperties(String prefix, int initialCapacity) {
        this.map = new HashMap<String, Object>(initialCapacity);
        this.prefix = prefix;
    }

    @Override
    public boolean hasProperty(String key) {
        return this.map.containsKey(this.prefixedKey(key));
    }

    @Override
    public Object getProperty(String key) {
        return this.map.get(this.prefixedKey(key));
    }

    @Override
    public Object getProperty(String key, Object defaultValue) {
        if (!this.hasProperty(key)) {
            return defaultValue;
        }
        return this.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        this.baseSetProperty(key, value);
    }

    private void baseSetProperty(String key, Object value) {
        this.map.put(this.prefixedKey(key), value);
    }

    private Object baseRemoveProperty(String key) {
        return this.map.remove(this.prefixedKey(key));
    }

    @Override
    public Object removeProperty(String key) {
        return this.baseRemoveProperty(key);
    }

    @Override
    public Iterable<String> getPropertyKeys() {
        return new RemovePrefixIterableWrapper(this.map.keySet(), this.prefix);
    }

    @Override
    public void setPropertiesFrom(Map<String, Object> propertiesMap) {
        this.map.clear();
        for (String key : propertiesMap.keySet()) {
            this.baseSetProperty(key, propertiesMap.get(key));
        }
    }

    @Override
    public DynamicProperties createFrom(Map<String, Object> map) {
        PrefixedDynamicProperties d = new PrefixedDynamicProperties(this.prefix, map.size());
        d.setPropertiesFrom(map);
        return d;
    }

    @Override
    public Map<String, Object> asMap() {
        HashMap<String, Object> result = new HashMap<String, Object>(this.map.size());
        for (String key : this.getPropertyKeys()) {
            result.put(key, this.getProperty(key));
        }
        return result;
    }

    public boolean setPropertyIfPrefixed(String key, Object value) {
        if (this.isPrefixedKey(key)) {
            this.setPrefixedProperty(key, value);
            return true;
        }
        return false;
    }

    public boolean isPrefixedKey(String key) {
        PrefixUtil util = new PrefixUtil(this.prefix);
        return util.hasPrefix(key);
    }

    private String prefixedKey(String key) {
        return PrefixUtil.prefixKey(this.prefix, key);
    }

    public Object getPrefixedProperty(String key) {
        return this.map.get(key);
    }

    public void setPrefixedProperty(String key, Object value) {
        this.map.put(key, value);
    }

    public boolean hasPrefixedProperty(String key) {
        return this.map.containsKey(key);
    }

    public Set<String> getPrefixedPropertyKeys() {
        return this.map.keySet();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
        result = 31 * result + (this.prefix == null ? 0 : this.prefix.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrefixedDynamicProperties other = (PrefixedDynamicProperties)obj;
        if (this.map == null ? other.map != null : !this.map.equals(other.map)) {
            return false;
        }
        return !(this.prefix == null ? other.prefix != null : !this.prefix.equals(other.prefix));
    }

    private static class SerializationProxy<T>
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map actualMapContent;
        private String prefix;

        SerializationProxy(PrefixedDynamicProperties prefixedDynamicProperties) {
            this.actualMapContent = prefixedDynamicProperties.map;
            this.prefix = prefixedDynamicProperties.prefix;
        }

        private Object readResolve() {
            PrefixedDynamicProperties val = new PrefixedDynamicProperties(this.prefix);
            val.setPropertiesFrom(this.actualMapContent);
            return val;
        }
    }

    private static class RemovePrefixIterableWrapper
    implements Iterable<String> {
        private final Iterable<String> iterable;
        private final String prefix;

        RemovePrefixIterableWrapper(Iterable<String> iterable, String prefix) {
            this.iterable = iterable;
            this.prefix = prefix;
        }

        @Override
        public Iterator<String> iterator() {
            return new RemovePrefixIteratorWrapper(this.iterable.iterator(), this.prefix);
        }

        private static class RemovePrefixIteratorWrapper
        implements Iterator<String> {
            private final Iterator<String> it;
            private final PrefixUtil prefixUtil;

            private RemovePrefixIteratorWrapper(Iterator<String> it, String prefix) {
                this.prefixUtil = new PrefixUtil(prefix);
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public String next() {
                return this.prefixUtil.removePrefix(this.it.next());
            }

            @Override
            public void remove() {
                this.it.remove();
            }
        }
    }

    private static class PrefixUtil {
        private final String prefix;
        private static final String DIVIDER = "-";

        public PrefixUtil(String prefix) {
            this.prefix = prefix + DIVIDER;
        }

        boolean hasPrefix(String s) {
            return s.startsWith(this.prefix);
        }

        public String removePrefix(String s) {
            if (this.hasPrefix(s)) {
                return s.substring(this.prefix.length());
            }
            return s;
        }

        public static String prefixKey(String prefix, String key) {
            return prefix + DIVIDER + key;
        }
    }
}

