/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.index.lucene.ValueContext;
import org.springframework.data.neo4j.fieldaccess.PropertyConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.parser.Part;

class StartClause {
    private final SortedMap<Integer, PartInfo> partInfos = new TreeMap<Integer, PartInfo>();

    public StartClause(PartInfo partInfo) {
        this.partInfos.put(partInfo.getParameterIndex(), partInfo);
    }

    public String toString() {
        PartInfo partInfo = this.getPartInfo();
        String identifier = partInfo.getIdentifier();
        String indexName = partInfo.getIndexName();
        int parameterIndex = partInfo.getParameterIndex();
        if (this.shouldRenderQuery()) {
            return String.format(QueryTemplates.START_CLAUSE_INDEX_QUERY, identifier, indexName, parameterIndex);
        }
        return String.format(QueryTemplates.START_CLAUSE_INDEX_LOOKUP, identifier, indexName, partInfo.getNeo4jPropertyName(), parameterIndex);
    }

    private boolean shouldRenderQuery() {
        PartInfo partInfo = this.getPartInfo();
        return partInfo.isFullText() || EnumSet.of(Part.Type.LIKE, Part.Type.STARTING_WITH, Part.Type.CONTAINING, Part.Type.ENDING_WITH).contains(partInfo.getType()) || this.partInfos.size() > 1;
    }

    public Map<Parameter, Object> resolveParameters(Map<Parameter, Object> parameters, Neo4jTemplate template) {
        Map<Parameter, PartInfo> myParameters = this.findMyParameters(parameters.keySet());
        LinkedHashMap<Parameter, Object> result = new LinkedHashMap<Parameter, Object>(parameters);
        result.keySet().removeAll(myParameters.keySet());
        Map<PartInfo, Object> values = this.matchToPartsAndConvert(myParameters, parameters, template);
        Parameter firstParam = (Parameter)IteratorUtil.first(myParameters.keySet());
        if (this.shouldRenderQuery()) {
            result.put(firstParam, this.renderQuery(values));
        } else {
            Object value = IteratorUtil.first(values.values());
            result.put(firstParam, value);
        }
        return result;
    }

    private String renderQuery(Map<PartInfo, Object> values) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<PartInfo, Object> entry : values.entrySet()) {
            if (sb.length() > 0) {
                sb.append(" AND ");
            }
            PartInfo partInfo = entry.getKey();
            Object value = entry.getValue();
            sb.append(QueryTemplates.formatIndexQuery(partInfo, value));
        }
        return sb.toString();
    }

    private Map<PartInfo, Object> matchToPartsAndConvert(Map<Parameter, PartInfo> myParameters, Map<Parameter, Object> parameters, Neo4jTemplate template) {
        LinkedHashMap<PartInfo, Object> result = new LinkedHashMap<PartInfo, Object>();
        for (Map.Entry<Parameter, PartInfo> entry : myParameters.entrySet()) {
            Object value = parameters.get(entry.getKey());
            PartInfo partInfo = entry.getValue();
            Neo4jPersistentProperty property = partInfo.getLeafProperty();
            result.put(partInfo, this.convertIfNecessary(template, value, property));
        }
        return result;
    }

    private Object convertIfNecessary(Neo4jTemplate template, Object value, Neo4jPersistentProperty property) {
        if (property.isIndexedNumerically()) {
            return new ValueContext(value).indexNumeric();
        }
        if (property.isNeo4jPropertyType() && property.isNeo4jPropertyValue(value)) {
            return value;
        }
        PropertyConverter converter = new PropertyConverter(template.getConversionService(), property);
        return converter.serializePropertyValue(value);
    }

    private Map<Parameter, PartInfo> findMyParameters(Set<Parameter> parameters) {
        LinkedHashMap<Parameter, PartInfo> result = new LinkedHashMap<Parameter, PartInfo>();
        for (Parameter parameter : parameters) {
            PartInfo partInfo = (PartInfo)this.partInfos.get(parameter.getIndex());
            if (partInfo == null) continue;
            result.put(parameter, partInfo);
        }
        return result;
    }

    public PartInfo getPartInfo() {
        return (PartInfo)IteratorUtil.first(this.partInfos.values());
    }

    public boolean merge(PartInfo partInfo) {
        for (PartInfo info : this.partInfos.values()) {
            if (info.sameIdentifier(partInfo) && info.sameIndex(partInfo)) continue;
            return false;
        }
        this.partInfos.put(partInfo.getParameterIndex(), partInfo);
        return true;
    }

    public boolean sameIdentifier(PartInfo info) {
        for (PartInfo partInfo : this.partInfos.values()) {
            if (partInfo.sameIdentifier(info)) continue;
            return false;
        }
        return true;
    }

    public boolean sameIndex(PartInfo info) {
        for (PartInfo partInfo : this.partInfos.values()) {
            if (partInfo.sameIndex(info)) continue;
            return false;
        }
        return true;
    }
}

