/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.mapping;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.neo4j.mapping.EntityInstantiator;
import org.springframework.data.neo4j.mapping.EntityPersister;
import org.springframework.data.neo4j.mapping.ManagedEntity;
import org.springframework.data.neo4j.mapping.MappingPolicy;
import org.springframework.data.neo4j.mapping.Neo4jEntityConverter;
import org.springframework.data.neo4j.mapping.Neo4jPersistentEntity;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.support.mapping.EntityStateHandler;
import org.springframework.data.neo4j.support.mapping.EntityTools;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityConverterImpl;
import org.springframework.data.neo4j.support.mapping.Neo4jEntityFetchHandler;
import org.springframework.data.neo4j.support.mapping.Neo4jMappingContext;
import org.springframework.data.neo4j.support.mapping.Neo4jPersistentEntityImpl;

public class Neo4jEntityPersister
implements EntityPersister,
Neo4jEntityConverter<Object, Node> {
    Neo4jEntityConverter<Object, Node> nodeConverter;
    Neo4jEntityConverter<Object, Relationship> relationshipConverter;
    private EntityStateHandler entityStateHandler;
    private final Neo4jMappingContext mappingContext;

    public Neo4jEntityPersister(ConversionService conversionService, EntityTools<Node> nodeEntityTools, EntityTools<Relationship> relationshipEntityTools, Neo4jMappingContext mappingContext, EntityStateHandler entityStateHandler) {
        this.mappingContext = mappingContext;
        this.entityStateHandler = entityStateHandler;
        Neo4jEntityFetchHandler fetchHandler = new Neo4jEntityFetchHandler(entityStateHandler, conversionService, nodeEntityTools.getSourceStateTransmitter(), relationshipEntityTools.getSourceStateTransmitter());
        this.nodeConverter = new CachedConverter<Node>(new Neo4jEntityConverterImpl(mappingContext, conversionService, entityStateHandler, fetchHandler, nodeEntityTools));
        this.relationshipConverter = new CachedConverter<Relationship>(new Neo4jEntityConverterImpl(mappingContext, conversionService, entityStateHandler, fetchHandler, relationshipEntityTools));
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromStoredType(S state, MappingPolicy mappingPolicy) {
        return this.createEntityFromState(state, null, mappingPolicy);
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromStoredType(S state) {
        return this.createEntityFromState(state, null, null);
    }

    @Override
    public <S extends PropertyContainer, T> T createEntityFromState(S state, Class<T> type, MappingPolicy mappingPolicy) {
        if (state == null) {
            throw new IllegalArgumentException("state has to be either a Node or Relationship, but is null");
        }
        if (this.isNode(state)) {
            return this.nodeConverter.read(type, (Node)state, mappingPolicy);
        }
        if (this.isRelationship(state)) {
            return this.relationshipConverter.read(type, (Relationship)state, mappingPolicy);
        }
        throw new IllegalArgumentException("state has to be either a Node or Relationship");
    }

    private boolean isRelationship(PropertyContainer state) {
        return state instanceof Relationship;
    }

    private boolean isNode(PropertyContainer state) {
        return state instanceof Node;
    }

    @Override
    public <T> T projectTo(Object entity, Class<T> targetType) {
        return this.projectTo(entity, targetType, this.getMappingPolicy(targetType));
    }

    @Override
    public <T> T projectTo(Object entity, Class<T> targetType, MappingPolicy mappingPolicy) {
        if (targetType.isInstance(entity)) {
            return (T)entity;
        }
        Object state = this.getPersistentState(entity);
        MappingPolicy newPolicy = mappingPolicy == null ? this.getMappingPolicy(targetType) : mappingPolicy;
        return this.createEntityFromState(state, targetType, newPolicy);
    }

    public <S extends PropertyContainer> S getPersistentState(Object entity) {
        return this.entityStateHandler.getPersistentState(entity);
    }

    public Object persist(Object entity, MappingPolicy mappingPolicy) {
        Class<?> type = entity.getClass();
        if (this.isManaged(entity)) {
            return ((ManagedEntity)entity).persist();
        }
        return this.persist(entity, type, mappingPolicy);
    }

    public boolean isManaged(Object entity) {
        return this.entityStateHandler.isManaged(entity);
    }

    private Object persist(Object entity, Class<?> type, MappingPolicy mappingPolicy) {
        if (this.isNodeEntity(type)) {
            Node node = (Node)this.getPersistentState(entity);
            this.nodeConverter.write(entity, node, mappingPolicy);
            return this.createEntityFromState(this.getPersistentState(entity), type, this.getMappingPolicy(type));
        }
        if (this.isRelationshipEntity((Class)type)) {
            Relationship relationship = (Relationship)this.getPersistentState(entity);
            this.relationshipConverter.write(entity, relationship, mappingPolicy);
            return this.createEntityFromState(this.getPersistentState(entity), type, this.getMappingPolicy(type));
        }
        throw new IllegalArgumentException("@NodeEntity or @RelationshipEntity annotation required on domain class" + type);
    }

    @Override
    public boolean isNodeEntity(Class<?> targetType) {
        return this.mappingContext.isNodeEntity(targetType);
    }

    @Override
    public MappingPolicy getMappingPolicy(Class<?> targetType) {
        return this.getPersistentEntity(targetType).getMappingPolicy();
    }

    private Neo4jPersistentEntityImpl<?> getPersistentEntity(Class<?> targetType) {
        return (Neo4jPersistentEntityImpl)this.mappingContext.getPersistentEntity(targetType);
    }

    public boolean isRelationshipEntity(Class targetType) {
        return this.mappingContext.isRelationshipEntity(targetType);
    }

    public <S extends PropertyContainer> void setPersistentState(Object entity, S state) {
        this.entityStateHandler.setPersistentState(entity, state);
    }

    @Override
    public MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> getMappingContext() {
        return this.mappingContext;
    }

    @Override
    public ConversionService getConversionService() {
        return this.nodeConverter.getConversionService();
    }

    @Override
    public <R> R read(Class<R> type, Node source, MappingPolicy mappingPolicy) {
        return this.createEntityFromState(source, type, mappingPolicy);
    }

    @Override
    public <R> R loadEntity(R entity, Node source, MappingPolicy mappingPolicy, Neo4jPersistentEntityImpl<R> persistentEntity) {
        return this.nodeConverter.loadEntity(entity, source, mappingPolicy, persistentEntity);
    }

    @Override
    public void write(Object source, Node sink, MappingPolicy mappingPolicy) {
        this.nodeConverter.write(source, sink, mappingPolicy);
    }

    public static class CachedConverter<S extends PropertyContainer>
    implements Neo4jEntityConverter<Object, S> {
        private final Neo4jEntityConverter<Object, S> delegate;

        public CachedConverter(Neo4jEntityConverter<Object, S> delegate) {
            this.delegate = delegate;
        }

        @Override
        public MappingContext<? extends Neo4jPersistentEntity<?>, Neo4jPersistentProperty> getMappingContext() {
            return this.delegate.getMappingContext();
        }

        @Override
        public ConversionService getConversionService() {
            return this.delegate.getConversionService();
        }

        @Override
        public <R> R loadEntity(R entity, S source, MappingPolicy mappingPolicy, Neo4jPersistentEntityImpl<R> persistentEntity) {
            return this.delegate.loadEntity(entity, source, mappingPolicy, persistentEntity);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <R> R read(Class<R> type, S state, MappingPolicy mappingPolicy) {
            try {
                if (state == null) {
                    throw new IllegalArgumentException("State must not be null");
                }
                StackedEntityCache.push();
                if (StackedEntityCache.contains(state, mappingPolicy)) {
                    Object t = StackedEntityCache.get(state, mappingPolicy);
                    return (R)t;
                }
                R r = StackedEntityCache.add(state, this.delegate.read(type, state, mappingPolicy), mappingPolicy);
                return r;
            }
            finally {
                StackedEntityCache.pop();
            }
        }

        @Override
        public void write(Object source, S sink, MappingPolicy mappingPolicy) {
            this.delegate.write(source, sink, mappingPolicy);
        }
    }

    public static class CachedInstantiator<S extends PropertyContainer>
    implements EntityInstantiator<S> {
        private final EntityInstantiator<S> delegate;

        public CachedInstantiator(EntityInstantiator<S> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T createEntityFromState(S state, Class<T> type, MappingPolicy mappingPolicy) {
            try {
                if (state == null) {
                    throw new IllegalArgumentException("State must not be null");
                }
                StackedEntityCache.push();
                if (StackedEntityCache.contains(state, mappingPolicy)) {
                    Object t = StackedEntityCache.get(state, mappingPolicy);
                    return t;
                }
                T newInstance = this.delegate.createEntityFromState(state, type, mappingPolicy);
                T t = StackedEntityCache.add(state, newInstance, mappingPolicy);
                return t;
            }
            finally {
                StackedEntityCache.pop();
            }
        }
    }

    static class StackedEntityCache {
        private long depth;
        private final Map<Entry, Object> objects = new HashMap<Entry, Object>();
        private static ThreadLocal<StackedEntityCache> stackedEntityCache = new ThreadLocal<StackedEntityCache>(){

            @Override
            protected StackedEntityCache initialValue() {
                return new StackedEntityCache();
            }
        };

        StackedEntityCache() {
        }

        public static void push() {
            ++StackedEntityCache.cache().depth;
        }

        public static void pop() {
            if (--StackedEntityCache.cache().depth == 0L) {
                stackedEntityCache.remove();
            }
        }

        public static <T> T get(PropertyContainer state, MappingPolicy mappingPolicy) {
            return (T)StackedEntityCache.cache().objects.get(new Entry(state, mappingPolicy));
        }

        public static <T> T add(PropertyContainer state, T value, MappingPolicy mappingPolicy) {
            StackedEntityCache.cache().objects.put(new Entry(state, mappingPolicy), value);
            return value;
        }

        private static StackedEntityCache cache() {
            return stackedEntityCache.get();
        }

        public static boolean contains(PropertyContainer state, MappingPolicy mappingPolicy) {
            return StackedEntityCache.cache().objects.containsKey(new Entry(state, mappingPolicy));
        }

        private static class Entry {
            PropertyContainer state;

            Entry(PropertyContainer state, MappingPolicy mappingPolicy) {
                this.state = state;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Entry entry = (Entry)o;
                return this.state.equals(entry.state);
            }

            public int hashCode() {
                return 31 * this.state.hashCode();
            }
        }
    }
}

