/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.context.PersistentPropertyPath;
import org.springframework.data.neo4j.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.repository.query.PartInfo;
import org.springframework.data.neo4j.repository.query.QueryTemplates;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class WhereClause {
    private static final Map<Part.Type, String> SYMBOLS;
    private final PartInfo partInfo;

    public WhereClause(PersistentPropertyPath<Neo4jPersistentProperty> path, String variable, Part.Type type, int index, PartInfo partInfo) {
        Assert.notNull((Object)partInfo.getType());
        this.partInfo = partInfo;
    }

    public String toString() {
        String propertyName = this.partInfo.getNeo4jPropertyName();
        String operator = SYMBOLS.get(this.partInfo.getType());
        String variable = this.partInfo.getVariable();
        if (this.partInfo.getType().getNumberOfArguments() == 0) {
            return String.format("%s.%s %s ", variable, propertyName, operator);
        }
        return String.format(QueryTemplates.WHERE_CLAUSE_1, variable, propertyName, operator, this.partInfo.getParameterIndex());
    }

    public PartInfo getPartInfo() {
        return this.partInfo;
    }

    static {
        HashMap<Part.Type, String> symbols = new HashMap<Part.Type, String>();
        symbols.put(Part.Type.GREATER_THAN, ">");
        symbols.put(Part.Type.GREATER_THAN_EQUAL, ">=");
        symbols.put(Part.Type.LESS_THAN, "<");
        symbols.put(Part.Type.LESS_THAN_EQUAL, "<=");
        symbols.put(Part.Type.NEGATING_SIMPLE_PROPERTY, "!=");
        symbols.put(Part.Type.SIMPLE_PROPERTY, "=");
        symbols.put(Part.Type.LIKE, "=~");
        symbols.put(Part.Type.IS_NULL, "is null");
        SYMBOLS = Collections.unmodifiableMap(symbols);
    }
}

