/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.query;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.neo4j.conversion.ResultConverter;
import org.springframework.data.neo4j.core.TypeRepresentationStrategy;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public class EntityResultConverter2<R>
implements ResultConverter<Object, R> {
    private final TypeRepresentationStrategy nodeTypeRepresentationStrategy;
    private final TypeRepresentationStrategy relationshipTypeRepresentationStrategy;
    private final ConversionService conversionService;

    public EntityResultConverter2(GraphDatabaseContext ctx) {
        this.conversionService = ctx.getConversionService();
        this.nodeTypeRepresentationStrategy = ctx.getNodeTypeRepresentationStrategy();
        this.relationshipTypeRepresentationStrategy = ctx.getRelationshipTypeRepresentationStrategy();
    }

    @Override
    public R convert(Object value, Class<R> type) {
        if (type == null) {
            return (R)this.convertValue(value);
        }
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        if (value instanceof Node) {
            return this.nodeTypeRepresentationStrategy.createEntity((Node)value, type);
        }
        if (value instanceof Relationship) {
            return this.relationshipTypeRepresentationStrategy.createEntity((Relationship)value, type);
        }
        return (R)this.conversionService.convert(value, type);
    }

    private Object convertValue(Object value) {
        if (value instanceof Node) {
            return this.nodeTypeRepresentationStrategy.createEntity((Node)value);
        }
        if (value instanceof Relationship) {
            return this.relationshipTypeRepresentationStrategy.createEntity((Relationship)value);
        }
        return value;
    }
}

