/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.repository;

import org.neo4j.graphdb.PropertyContainer;
import org.springframework.data.neo4j.annotation.NodeEntity;
import org.springframework.data.neo4j.annotation.RelationshipEntity;
import org.springframework.data.neo4j.core.GraphBacked;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.repository.GraphEntityInformation;
import org.springframework.data.neo4j.support.GraphDatabaseContext;
import org.springframework.data.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.neo4j.support.relationship.Neo4jRelationshipBacking;
import org.springframework.data.repository.core.support.AbstractEntityInformation;

public class GraphMetamodelEntityInformation<S extends PropertyContainer, T extends GraphBacked<S>>
extends AbstractEntityInformation<T, Long>
implements GraphEntityInformation<S, T> {
    private GraphDatabaseContext graphDatabaseContext;
    private final RelationshipEntity relationshipEntity;
    private final NodeEntity nodeEntity;

    public GraphMetamodelEntityInformation(Class domainClass, GraphDatabaseContext graphDatabaseContext) {
        super(domainClass);
        this.graphDatabaseContext = graphDatabaseContext;
        this.nodeEntity = this.getJavaType().getAnnotation(NodeEntity.class);
        this.relationshipEntity = this.getJavaType().getAnnotation(RelationshipEntity.class);
    }

    @Override
    public boolean isNodeEntity() {
        return this.nodeEntity != null;
    }

    @Override
    public boolean isPartialEntity() {
        return this.nodeEntity != null && this.nodeEntity.partial();
    }

    @Override
    public boolean isRelationshipEntity() {
        return this.relationshipEntity != null;
    }

    public boolean isNew(T entity) {
        return entity.hasPersistentState();
    }

    public Long getId(T entity) {
        return this.isNodeEntity() ? Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_neo4j_core_NodeBacked$getNodeId((NodeBacked)entity) : Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_neo4j_core_RelationshipBacked$getRelationshipId((RelationshipBacked)entity);
    }

    public Class<Long> getIdType() {
        return Long.class;
    }
}

