/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.util.Arrays;
import java.util.Collection;
import org.springframework.data.neo4j.core.RelationshipBacked;
import org.springframework.data.neo4j.fieldaccess.ConvertingNodePropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.DelegatingFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.FieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.IndexingPropertyFieldAccessorListenerFactory;
import org.springframework.data.neo4j.fieldaccess.PropertyFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.RelationshipNodeFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.TransientFieldAccessorFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public class RelationshipDelegatingFieldAccessorFactory
extends DelegatingFieldAccessorFactory<RelationshipBacked> {
    public RelationshipDelegatingFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        super(graphDatabaseContext);
    }

    @Override
    protected Collection<FieldAccessorListenerFactory<?>> createListenerFactories() {
        return Arrays.asList(new IndexingPropertyFieldAccessorListenerFactory(this.graphDatabaseContext, new PropertyFieldAccessorFactory(this.graphDatabaseContext.getConversionService()), new ConvertingNodePropertyFieldAccessorFactory(this.graphDatabaseContext.getConversionService())));
    }

    @Override
    protected Collection<? extends FieldAccessorFactory<?>> createAccessorFactories() {
        return Arrays.asList(new TransientFieldAccessorFactory(), new RelationshipNodeFieldAccessorFactory(this.graphDatabaseContext), new PropertyFieldAccessorFactory(this.graphDatabaseContext.getConversionService()), new ConvertingNodePropertyFieldAccessorFactory(this.graphDatabaseContext.getConversionService()));
    }
}

