/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.fieldaccess;

import java.lang.reflect.Field;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.neo4j.annotation.RelatedTo;
import org.springframework.data.neo4j.core.NodeBacked;
import org.springframework.data.neo4j.fieldaccess.FieldAccessor;
import org.springframework.data.neo4j.fieldaccess.NodeRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.fieldaccess.OneToNRelationshipFieldAccessorFactory;
import org.springframework.data.neo4j.support.GraphDatabaseContext;

public class ReadOnlyOneToNRelationshipFieldAccessorFactory
extends NodeRelationshipFieldAccessorFactory {
    public ReadOnlyOneToNRelationshipFieldAccessorFactory(GraphDatabaseContext graphDatabaseContext) {
        super(graphDatabaseContext);
    }

    @Override
    public boolean accept(Field f) {
        return Iterable.class.equals(f.getType()) && this.hasValidRelationshipAnnotation(f);
    }

    @Override
    public FieldAccessor<NodeBacked> forField(Field field) {
        RelatedTo relAnnotation = this.getRelationshipAnnotation(field);
        return new ReadOnlyOneToNRelationshipFieldAccessor((RelationshipType)this.typeFrom(field, relAnnotation), this.dirFrom(relAnnotation), this.targetFrom(field, relAnnotation), this.graphDatabaseContext, field);
    }

    public static class ReadOnlyOneToNRelationshipFieldAccessor
    extends OneToNRelationshipFieldAccessorFactory.OneToNRelationshipFieldAccessor {
        public ReadOnlyOneToNRelationshipFieldAccessor(RelationshipType type, Direction direction, Class<? extends NodeBacked> elementClass, GraphDatabaseContext graphDatabaseContext, Field field) {
            super(type, direction, elementClass, graphDatabaseContext, field);
        }

        @Override
        public boolean isWriteable(NodeBacked nodeBacked) {
            return false;
        }

        @Override
        public Object setValue(NodeBacked entity, Object newVal) {
            throw new InvalidDataAccessApiUsageException("Cannot set read-only relationship entity field.");
        }
    }
}

