/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.HashSet;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.springframework.data.graph.core.GraphBacked;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.neo4j.fieldaccess.AbstractNodeRelationshipFieldAccessor;
import org.springframework.data.graph.neo4j.support.GraphDatabaseContext;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;

public abstract class NodeToNodesRelationshipFieldAccessor<TARGET extends GraphBacked>
extends AbstractNodeRelationshipFieldAccessor<NodeBacked, Node, TARGET, Node> {
    public NodeToNodesRelationshipFieldAccessor(Class<? extends TARGET> clazz, GraphDatabaseContext graphDatabaseContext, Direction direction, RelationshipType type, Field field) {
        super(clazz, graphDatabaseContext, direction, type, field);
    }

    @Override
    protected Relationship obtainSingleRelationship(Node start, Node end) {
        Iterable existingRelationships = start.getRelationships(this.type, this.direction);
        for (Relationship existingRelationship : existingRelationships) {
            if (existingRelationship == null || !existingRelationship.getOtherNode(start).equals(end)) continue;
            return existingRelationship;
        }
        return start.createRelationshipTo(end, this.type);
    }

    @Override
    protected Iterable<Node> getStatesFromEntity(NodeBacked entity) {
        Node entityNode = this.getState(entity);
        HashSet<Node> result = new HashSet<Node>();
        for (Relationship rel : entityNode.getRelationships(this.type, this.direction)) {
            result.add(rel.getOtherNode(entityNode));
        }
        return result;
    }

    @Override
    protected Node getState(NodeBacked entity) {
        return Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$getPersistentState(entity);
    }
}

