/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.graph.neo4j.fieldaccess;

import java.lang.reflect.Field;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;
import org.neo4j.graphdb.Node;
import org.springframework.data.graph.core.EntityState;
import org.springframework.data.graph.core.NodeBacked;
import org.springframework.data.graph.core.RelationshipBacked;
import org.springframework.data.graph.neo4j.support.DoReturn;
import org.springframework.data.graph.neo4j.support.node.Neo4jNodeBacking;
import org.springframework.data.graph.neo4j.support.relationship.Neo4jRelationshipBacking;

public class ManagedFieldAccessorSet<ENTITY, T>
extends AbstractSet<T> {
    private final ENTITY entity;
    final Set<T> delegate;
    private final Field field;

    public ManagedFieldAccessorSet(ENTITY entity, Object newVal, Field field) {
        this.entity = entity;
        this.field = field;
        this.delegate = (Set)newVal;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator<T> iterator = this.delegate.iterator();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                iterator.remove();
                ManagedFieldAccessorSet.this.update();
            }
        };
    }

    private void update() {
        if (this.entity instanceof NodeBacked) {
            NodeBacked nodeBacked = (NodeBacked)this.entity;
            EntityState<NodeBacked, Node> entityState = Neo4jNodeBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_node_Neo4jNodeBacking$org_springframework_data_graph_core_NodeBacked$getEntityState(nodeBacked);
            this.updateValue(entityState);
        }
        if (this.entity instanceof RelationshipBacked) {
            RelationshipBacked relationshipBacked = (RelationshipBacked)this.entity;
            this.updateValue(Neo4jRelationshipBacking.ajc$interMethodDispatch1$org_springframework_data_graph_neo4j_support_relationship_Neo4jRelationshipBacking$org_springframework_data_graph_core_RelationshipBacked$getEntityState(relationshipBacked));
        }
    }

    private Object updateValue(EntityState entityState) {
        try {
            Object newValue = entityState.setValue(this.field, this.delegate);
            if (newValue instanceof DoReturn) {
                return DoReturn.unwrap(newValue);
            }
            this.field.setAccessible(true);
            this.field.set(this.entity, newValue);
            return newValue;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Could not update field " + this.field + " to new value of type " + this.delegate.getClass());
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(T e) {
        boolean res = this.delegate.add(e);
        if (res) {
            this.update();
        }
        return res;
    }
}

