/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.mongodb.repository.query.PartTreeMongoQuery;
import org.springframework.data.mongodb.repository.query.StringBasedAggregation;
import org.springframework.data.mongodb.repository.query.StringBasedMongoQuery;
import org.springframework.data.mongodb.repository.query.VectorSearchAggregation;
import org.springframework.data.mongodb.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.mongodb.repository.support.MongoEntityInformationSupport;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFragmentsContributor;
import org.springframework.data.mongodb.repository.support.SimpleMongoRepository;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.util.Assert;

public class MongoRepositoryFactory
extends RepositoryFactorySupport {
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
    private final MongoOperations operations;
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private MongoRepositoryFragmentsContributor fragmentsContributor = MongoRepositoryFragmentsContributor.DEFAULT;

    public MongoRepositoryFactory(MongoOperations mongoOperations) {
        Assert.notNull((Object)mongoOperations, (String)"MongoOperations must not be null");
        this.operations = mongoOperations;
        this.mappingContext = mongoOperations.getConverter().getMappingContext();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setFragmentsContributor(MongoRepositoryFragmentsContributor fragmentsContributor) {
        this.fragmentsContributor = fragmentsContributor;
    }

    public void setBeanClassLoader(@Nullable ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    protected ProjectionFactory getProjectionFactory(@Nullable ClassLoader classLoader, @Nullable BeanFactory beanFactory) {
        return this.operations.getConverter().getProjectionFactory();
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleMongoRepository.class;
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.operations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, MongoOperations operations) {
        return this.fragmentsContributor.contribute(metadata, (MongoEntityInformation<?, ?>)this.getEntityInformation(metadata), operations);
    }

    protected Object getTargetRepository(RepositoryInformation information) {
        EntityInformation entityInformation = this.getEntityInformation((RepositoryMetadata)information);
        Object targetRepository = this.getTargetRepositoryViaReflection(information, new Object[]{entityInformation, this.operations});
        if (targetRepository instanceof SimpleMongoRepository) {
            SimpleMongoRepository repository = (SimpleMongoRepository)targetRepository;
            repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        }
        return targetRepository;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(// Could not load outer class - annotation placement on inner may be incorrect
    @Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new MongoQueryLookupStrategy(this.operations, this.mappingContext, valueExpressionDelegate));
    }

    @Deprecated
    public <T, ID> MongoEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return MongoEntityInformationSupport.entityInformationFor(entity, null);
    }

    public MongoEntityInformation<?, ?> getEntityInformation(RepositoryMetadata metadata) {
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity(metadata.getDomainType());
        return MongoEntityInformationSupport.entityInformationFor(entity, metadata.getIdType());
    }

    private record MongoQueryLookupStrategy(MongoOperations operations, MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, ValueExpressionDelegate expressionSupport) implements QueryLookupStrategy
    {
        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            MongoQueryMethod queryMethod = new MongoQueryMethod(method, metadata, factory, this.mappingContext);
            queryMethod.verify();
            String namedQueryName = queryMethod.getNamedQueryName();
            if (namedQueries.hasQuery(namedQueryName)) {
                String namedQuery = namedQueries.getQuery(namedQueryName);
                return new StringBasedMongoQuery(namedQuery, queryMethod, this.operations, this.expressionSupport);
            }
            if (queryMethod.hasAnnotatedVectorSearch()) {
                return new VectorSearchAggregation(queryMethod, this.operations, this.expressionSupport);
            }
            if (queryMethod.hasAnnotatedAggregation()) {
                return new StringBasedAggregation(queryMethod, this.operations, this.expressionSupport);
            }
            if (queryMethod.hasAnnotatedQuery()) {
                return new StringBasedMongoQuery(queryMethod, this.operations, this.expressionSupport);
            }
            return new PartTreeMongoQuery(queryMethod, this.operations, this.expressionSupport);
        }
    }
}

