/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.data.mongodb.aot.LazyLoadingProxyAotProcessor;
import org.springframework.data.mongodb.aot.MongoAotPredicates;
import org.springframework.data.mongodb.repository.aot.MongoRepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.RepositoryRegistrationAotProcessor;
import org.springframework.data.util.TypeContributor;

public class AotMongoRepositoryPostProcessor
extends RepositoryRegistrationAotProcessor {
    private static final String MODULE_NAME = "mongodb";
    private final LazyLoadingProxyAotProcessor lazyLoadingProxyAotProcessor = new LazyLoadingProxyAotProcessor();

    protected void configureTypeContributions(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        super.configureTypeContributions(repositoryContext, generationContext);
        repositoryContext.getResolvedTypes().stream().filter(MongoAotPredicates.IS_SIMPLE_TYPE.negate()).forEach(type -> {
            TypeContributor.contribute((Class)type, it -> true, (GenerationContext)generationContext);
            this.lazyLoadingProxyAotProcessor.registerLazyLoadingProxyIfNeeded((Class<?>)type, generationContext);
        });
    }

    protected @Nullable MongoRepositoryContributor contributeAotRepository(AotRepositoryContext repositoryContext) {
        if (!repositoryContext.isGeneratedRepositoriesEnabled(MODULE_NAME)) {
            return null;
        }
        if (repositoryContext.getRepositoryInformation().isReactiveRepository()) {
            return null;
        }
        return new MongoRepositoryContributor(repositoryContext);
    }
}

