/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.query;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.MongoExpression;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class Field {
    private final Map<String, Object> criteria = new HashMap<String, Object>();
    private final Map<String, Object> slices = new HashMap<String, Object>();
    private final Map<String, Criteria> elemMatches = new HashMap<String, Criteria>();
    private @Nullable String positionKey;
    private int positionValue;

    @Contract(value="_ -> this")
    public Field include(String field) {
        Assert.notNull((Object)field, (String)"Key must not be null");
        this.criteria.put(field, 1);
        return this;
    }

    public FieldProjectionExpression project(MongoExpression expression) {
        return field -> this.projectAs(expression, field);
    }

    @Contract(value="_, _ -> this")
    public Field projectAs(MongoExpression expression, String field) {
        this.criteria.put(field, expression);
        return this;
    }

    @Contract(value="_ -> this")
    public Field include(String ... fields) {
        return this.include(Arrays.asList(fields));
    }

    @Contract(value="_ -> this")
    public Field include(Collection<String> fields) {
        Assert.notNull(fields, (String)"Keys must not be null");
        fields.forEach(this::include);
        return this;
    }

    @Contract(value="_ -> this")
    public Field exclude(String field) {
        Assert.notNull((Object)field, (String)"Key must not be null");
        this.criteria.put(field, 0);
        return this;
    }

    @Contract(value="_ -> this")
    public Field exclude(String ... fields) {
        return this.exclude(Arrays.asList(fields));
    }

    @Contract(value="_ -> this")
    public Field exclude(Collection<String> fields) {
        Assert.notNull(fields, (String)"Keys must not be null");
        fields.forEach(this::exclude);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Field slice(String field, int size) {
        Assert.notNull((Object)field, (String)"Key must not be null");
        this.slices.put(field, size);
        return this;
    }

    @Contract(value="_, _, _ -> this")
    public Field slice(String field, int offset, int size) {
        this.slices.put(field, Arrays.asList(offset, size));
        return this;
    }

    @Contract(value="_, _ -> this")
    public Field elemMatch(String field, Criteria elemMatchCriteria) {
        this.elemMatches.put(field, elemMatchCriteria);
        return this;
    }

    @Contract(value="_, _ -> this")
    public Field position(String field, int value) {
        Assert.hasText((String)field, (String)"DocumentField must not be null or empty");
        this.positionKey = field;
        this.positionValue = value;
        return this;
    }

    public Document getFieldsObject() {
        Document document = new Document(this.criteria);
        for (Map.Entry<String, Object> entry : this.slices.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$slice", entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.elemMatches.entrySet()) {
            document.put(entry.getKey(), (Object)new Document("$elemMatch", (Object)((Criteria)entry.getValue()).getCriteriaObject()));
        }
        if (this.positionKey != null) {
            document.put(this.positionKey + ".$", (Object)this.positionValue);
        }
        return document;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Field field = (Field)o;
        if (this.positionValue != field.positionValue) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.criteria, field.criteria)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.slices, field.slices)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.elemMatches, field.elemMatches)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.positionKey, (Object)field.positionKey);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.criteria);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.slices);
        result = 31 * result + ObjectUtils.nullSafeHashCode(this.elemMatches);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.positionKey);
        result = 31 * result + this.positionValue;
        return result;
    }

    public static interface FieldProjectionExpression {
        public Field as(String var1);
    }
}

