/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Collection;
import java.util.regex.Pattern;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.repository.ReadPreference;
import org.springframework.data.mongodb.repository.aot.AggregationBlocks;
import org.springframework.data.mongodb.repository.aot.DeleteBlocks;
import org.springframework.data.mongodb.repository.aot.GeoBlocks;
import org.springframework.data.mongodb.repository.aot.QueryBlocks;
import org.springframework.data.mongodb.repository.aot.UpdateBlocks;
import org.springframework.data.mongodb.repository.query.MongoQueryMethod;
import org.springframework.data.repository.aot.generate.AotQueryMethodGenerationContext;
import org.springframework.data.repository.aot.generate.ExpressionMarker;
import org.springframework.data.repository.aot.generate.MethodReturn;
import org.springframework.data.util.Streamable;
import org.springframework.javapoet.CodeBlock;
import org.springframework.util.ClassUtils;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

class MongoCodeBlocks {
    private static final Pattern PARAMETER_BINDING_PATTERN = Pattern.compile("\\?(\\d+)");
    private static final Pattern EXPRESSION_BINDING_PATTERN = Pattern.compile("[\\?:][#$]\\{.*\\}");
    private static final Pattern VALUE_EXPRESSION_PATTERN = Pattern.compile("^#\\{.*}$");

    MongoCodeBlocks() {
    }

    static QueryBlocks.QueryCodeBlockBuilder queryBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryBlocks.QueryCodeBlockBuilder(context, queryMethod);
    }

    static QueryBlocks.QueryExecutionCodeBlockBuilder queryExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new QueryBlocks.QueryExecutionCodeBlockBuilder(context, queryMethod);
    }

    static DeleteBlocks.DeleteExecutionCodeBlockBuilder deleteExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new DeleteBlocks.DeleteExecutionCodeBlockBuilder(context, queryMethod);
    }

    static UpdateBlocks.UpdateCodeBlockBuilder updateBlockBuilder(AotQueryMethodGenerationContext context) {
        return new UpdateBlocks.UpdateCodeBlockBuilder(context);
    }

    static UpdateBlocks.UpdateExecutionCodeBlockBuilder updateExecutionBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new UpdateBlocks.UpdateExecutionCodeBlockBuilder(context, queryMethod);
    }

    static AggregationBlocks.AggregationCodeBlockBuilder aggregationBlockBuilder(AotQueryMethodGenerationContext context, SimpleTypeHolder simpleTypeHolder, MongoQueryMethod queryMethod) {
        return new AggregationBlocks.AggregationCodeBlockBuilder(context, simpleTypeHolder, queryMethod);
    }

    static AggregationBlocks.AggregationExecutionCodeBlockBuilder aggregationExecutionBlockBuilder(AotQueryMethodGenerationContext context, SimpleTypeHolder simpleTypeHolder, MongoQueryMethod queryMethod) {
        return new AggregationBlocks.AggregationExecutionCodeBlockBuilder(context, simpleTypeHolder, queryMethod);
    }

    static GeoBlocks.GeoNearCodeBlockBuilder geoNearBlockBuilder(AotQueryMethodGenerationContext context, MongoQueryMethod queryMethod) {
        return new GeoBlocks.GeoNearCodeBlockBuilder(context, queryMethod);
    }

    static GeoBlocks.GeoNearExecutionCodeBlockBuilder geoNearExecutionBlockBuilder(AotQueryMethodGenerationContext context) {
        return new GeoBlocks.GeoNearExecutionCodeBlockBuilder(context);
    }

    static CodeBlock asDocument(ExpressionMarker expressionMarker, String source, String argNames) {
        return MongoCodeBlocks.asDocument(expressionMarker, source, CodeBlock.of((String)"$L", (Object[])new Object[]{argNames}));
    }

    static CodeBlock asDocument(ExpressionMarker expressionMarker, String source, CodeBlock arguments) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (!StringUtils.hasText((String)source)) {
            builder.add("new $T()", new Object[]{Document.class});
        } else if (MongoCodeBlocks.containsPlaceholder(source)) {
            if (arguments.isEmpty()) {
                builder.add("bindParameters($L, $S)", new Object[]{expressionMarker.enclosingMethod(), source});
            } else {
                builder.add("bindParameters($L, $S, $L)", new Object[]{expressionMarker.enclosingMethod(), source, arguments});
            }
        } else {
            builder.add("parse($S)", new Object[]{source});
        }
        return builder.build();
    }

    static CodeBlock renderExpressionToDocument(@Nullable String source, String variableName, String argNames) {
        CodeBlock.Builder builder = CodeBlock.builder();
        if (!StringUtils.hasText((String)source)) {
            builder.addStatement("$1T $2L = new $1T()", new Object[]{Document.class, variableName});
        } else if (MongoCodeBlocks.containsPlaceholder(source)) {
            builder.add("$T $L = bindParameters(ExpressionMarker.class.getEnclosingMethod(), $S$L);\n", new Object[]{Document.class, variableName, source, argNames});
        } else {
            builder.addStatement("$1T $2L = parse($3S)", new Object[]{Document.class, variableName, source});
        }
        return builder.build();
    }

    static CodeBlock evaluateNumberPotentially(String value, Class<? extends Number> targetType, AotQueryMethodGenerationContext context) {
        try {
            Number number = NumberUtils.parseNumber((String)value, targetType);
            return CodeBlock.of((String)"$L", (Object[])new Object[]{number});
        }
        catch (IllegalArgumentException e) {
            Object parameterNames = StringUtils.collectionToDelimitedString((Collection)context.getAllParameterNames(), (String)", ");
            parameterNames = StringUtils.hasText((String)parameterNames) ? ", " + (String)parameterNames : "";
            CodeBlock.Builder builder = CodeBlock.builder();
            builder.add("($T) evaluate($L, $S$L)", new Object[]{targetType, context.getExpressionMarker().enclosingMethod(), value, parameterNames});
            return builder.build();
        }
    }

    static boolean containsPlaceholder(String source) {
        return MongoCodeBlocks.containsIndexedPlaceholder(source) || MongoCodeBlocks.containsNamedPlaceholder(source);
    }

    static boolean containsExpression(String source) {
        return VALUE_EXPRESSION_PATTERN.matcher(source).find();
    }

    static boolean containsNamedPlaceholder(String source) {
        return EXPRESSION_BINDING_PATTERN.matcher(source).find();
    }

    static boolean containsIndexedPlaceholder(String source) {
        return PARAMETER_BINDING_PATTERN.matcher(source).find();
    }

    static void appendReadPreference(AotQueryMethodGenerationContext context, CodeBlock.Builder builder, String queryVariableName) {
        String readPreference;
        MergedAnnotation readPreferenceAnnotation = context.getAnnotation(ReadPreference.class);
        String string = readPreference = readPreferenceAnnotation.isPresent() ? readPreferenceAnnotation.getString("value") : null;
        if (StringUtils.hasText((String)readPreference)) {
            builder.addStatement("$L.withReadPreference($T.valueOf($S))", new Object[]{queryVariableName, com.mongodb.ReadPreference.class, readPreference});
        }
    }

    public static CodeBlock potentiallyWrapStreamable(MethodReturn methodReturn, CodeBlock returningIterable) {
        Class returnType = methodReturn.toClass();
        if (returnType.equals(Streamable.class)) {
            return CodeBlock.of((String)"$T.of($L)", (Object[])new Object[]{Streamable.class, returningIterable});
        }
        if (ClassUtils.isAssignable(Streamable.class, (Class)returnType)) {
            return CodeBlock.of((String)"($1T) $2T.getSharedInstance().convert($3T.of($4L), $5T.valueOf($3T.class), $5T.valueOf($1T.class))", (Object[])new Object[]{returnType, DefaultConversionService.class, Streamable.class, returningIterable, TypeDescriptor.class});
        }
        return returningIterable;
    }
}

