/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.spel;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.spel.ExpressionNode;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.MethodReference;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MethodReferenceNode
extends ExpressionNode {
    private static final Map<String, AggregationMethodReference> FUNCTIONS;

    MethodReferenceNode(MethodReference reference, ExpressionState state) {
        super((SpelNode)reference, state);
    }

    public @Nullable AggregationMethodReference getMethodReference() {
        String name = this.getName();
        String methodName = name.substring(0, name.indexOf(40));
        return FUNCTIONS.get(methodName);
    }

    static {
        HashMap<String, AggregationMethodReference> map = new HashMap<String, AggregationMethodReference>();
        map.put("and", AggregationMethodReference.arrayArgRef().forOperator("$and"));
        map.put("or", AggregationMethodReference.arrayArgRef().forOperator("$or"));
        map.put("not", AggregationMethodReference.arrayArgRef().forOperator("$not"));
        map.put("setEquals", AggregationMethodReference.arrayArgRef().forOperator("$setEquals"));
        map.put("setIntersection", AggregationMethodReference.arrayArgRef().forOperator("$setIntersection"));
        map.put("setUnion", AggregationMethodReference.arrayArgRef().forOperator("$setUnion"));
        map.put("setDifference", AggregationMethodReference.arrayArgRef().forOperator("$setDifference"));
        map.put("setIsSubset", AggregationMethodReference.arrayArgRef().forOperator("$setIsSubset"));
        map.put("anyElementTrue", AggregationMethodReference.arrayArgRef().forOperator("$anyElementTrue"));
        map.put("allElementsTrue", AggregationMethodReference.arrayArgRef().forOperator("$allElementsTrue"));
        map.put("cmp", AggregationMethodReference.arrayArgRef().forOperator("$cmp"));
        map.put("eq", AggregationMethodReference.arrayArgRef().forOperator("$eq"));
        map.put("gt", AggregationMethodReference.arrayArgRef().forOperator("$gt"));
        map.put("gte", AggregationMethodReference.arrayArgRef().forOperator("$gte"));
        map.put("lt", AggregationMethodReference.arrayArgRef().forOperator("$lt"));
        map.put("lte", AggregationMethodReference.arrayArgRef().forOperator("$lte"));
        map.put("ne", AggregationMethodReference.arrayArgRef().forOperator("$ne"));
        map.put("rank", AggregationMethodReference.emptyRef().forOperator("$rank"));
        map.put("denseRank", AggregationMethodReference.emptyRef().forOperator("$denseRank"));
        map.put("documentNumber", AggregationMethodReference.emptyRef().forOperator("$documentNumber"));
        map.put("shift", AggregationMethodReference.mapArgRef().forOperator("$shift").mappingParametersTo("output", "by", "default"));
        map.put("abs", AggregationMethodReference.singleArgRef().forOperator("$abs"));
        map.put("add", AggregationMethodReference.arrayArgRef().forOperator("$add"));
        map.put("ceil", AggregationMethodReference.singleArgRef().forOperator("$ceil"));
        map.put("divide", AggregationMethodReference.arrayArgRef().forOperator("$divide"));
        map.put("exp", AggregationMethodReference.singleArgRef().forOperator("$exp"));
        map.put("floor", AggregationMethodReference.singleArgRef().forOperator("$floor"));
        map.put("ln", AggregationMethodReference.singleArgRef().forOperator("$ln"));
        map.put("log", AggregationMethodReference.arrayArgRef().forOperator("$log"));
        map.put("log10", AggregationMethodReference.singleArgRef().forOperator("$log10"));
        map.put("mod", AggregationMethodReference.arrayArgRef().forOperator("$mod"));
        map.put("multiply", AggregationMethodReference.arrayArgRef().forOperator("$multiply"));
        map.put("pow", AggregationMethodReference.arrayArgRef().forOperator("$pow"));
        map.put("sqrt", AggregationMethodReference.singleArgRef().forOperator("$sqrt"));
        map.put("subtract", AggregationMethodReference.arrayArgRef().forOperator("$subtract"));
        map.put("trunc", AggregationMethodReference.singleArgRef().forOperator("$trunc"));
        map.put("round", AggregationMethodReference.arrayArgRef().forOperator("$round"));
        map.put("derivative", AggregationMethodReference.mapArgRef().forOperator("$derivative").mappingParametersTo("input", "unit"));
        map.put("integral", AggregationMethodReference.mapArgRef().forOperator("$integral").mappingParametersTo("input", "unit"));
        map.put("sin", AggregationMethodReference.singleArgRef().forOperator("$sin"));
        map.put("sinh", AggregationMethodReference.singleArgRef().forOperator("$sinh"));
        map.put("asin", AggregationMethodReference.singleArgRef().forOperator("$asin"));
        map.put("asinh", AggregationMethodReference.singleArgRef().forOperator("$asinh"));
        map.put("cos", AggregationMethodReference.singleArgRef().forOperator("$cos"));
        map.put("cosh", AggregationMethodReference.singleArgRef().forOperator("$cosh"));
        map.put("acos", AggregationMethodReference.singleArgRef().forOperator("$acos"));
        map.put("acosh", AggregationMethodReference.singleArgRef().forOperator("$acosh"));
        map.put("tan", AggregationMethodReference.singleArgRef().forOperator("$tan"));
        map.put("tanh", AggregationMethodReference.singleArgRef().forOperator("$tanh"));
        map.put("rand", AggregationMethodReference.emptyRef().forOperator("$rand"));
        map.put("atan", AggregationMethodReference.singleArgRef().forOperator("$atan"));
        map.put("atan2", AggregationMethodReference.arrayArgRef().forOperator("$atan2"));
        map.put("atanh", AggregationMethodReference.singleArgRef().forOperator("$atanh"));
        map.put("concat", AggregationMethodReference.arrayArgRef().forOperator("$concat"));
        map.put("strcasecmp", AggregationMethodReference.arrayArgRef().forOperator("$strcasecmp"));
        map.put("substr", AggregationMethodReference.arrayArgRef().forOperator("$substr"));
        map.put("toLower", AggregationMethodReference.singleArgRef().forOperator("$toLower"));
        map.put("toUpper", AggregationMethodReference.singleArgRef().forOperator("$toUpper"));
        map.put("indexOfBytes", AggregationMethodReference.arrayArgRef().forOperator("$indexOfBytes"));
        map.put("indexOfCP", AggregationMethodReference.arrayArgRef().forOperator("$indexOfCP"));
        map.put("split", AggregationMethodReference.arrayArgRef().forOperator("$split"));
        map.put("strLenBytes", AggregationMethodReference.singleArgRef().forOperator("$strLenBytes"));
        map.put("strLenCP", AggregationMethodReference.singleArgRef().forOperator("$strLenCP"));
        map.put("substrCP", AggregationMethodReference.arrayArgRef().forOperator("$substrCP"));
        map.put("trim", AggregationMethodReference.mapArgRef().forOperator("$trim").mappingParametersTo("input", "chars"));
        map.put("ltrim", AggregationMethodReference.mapArgRef().forOperator("$ltrim").mappingParametersTo("input", "chars"));
        map.put("rtrim", AggregationMethodReference.mapArgRef().forOperator("$rtrim").mappingParametersTo("input", "chars"));
        map.put("regexFind", AggregationMethodReference.mapArgRef().forOperator("$regexFind").mappingParametersTo("input", "regex", "options"));
        map.put("regexFindAll", AggregationMethodReference.mapArgRef().forOperator("$regexFindAll").mappingParametersTo("input", "regex", "options"));
        map.put("regexMatch", AggregationMethodReference.mapArgRef().forOperator("$regexMatch").mappingParametersTo("input", "regex", "options"));
        map.put("replaceOne", AggregationMethodReference.mapArgRef().forOperator("$replaceOne").mappingParametersTo("input", "find", "replacement"));
        map.put("replaceAll", AggregationMethodReference.mapArgRef().forOperator("$replaceAll").mappingParametersTo("input", "find", "replacement"));
        map.put("meta", AggregationMethodReference.singleArgRef().forOperator("$meta"));
        map.put("arrayElemAt", AggregationMethodReference.arrayArgRef().forOperator("$arrayElemAt"));
        map.put("concatArrays", AggregationMethodReference.arrayArgRef().forOperator("$concatArrays"));
        map.put("filter", AggregationMethodReference.mapArgRef().forOperator("$filter").mappingParametersTo("input", "as", "cond"));
        map.put("first", AggregationMethodReference.singleArgRef().forOperator("$first"));
        map.put("isArray", AggregationMethodReference.singleArgRef().forOperator("$isArray"));
        map.put("last", AggregationMethodReference.singleArgRef().forOperator("$last"));
        map.put("size", AggregationMethodReference.singleArgRef().forOperator("$size"));
        map.put("slice", AggregationMethodReference.arrayArgRef().forOperator("$slice"));
        map.put("sortArray", AggregationMethodReference.mapArgRef().forOperator("$sortArray").mappingParametersTo("input", "sortBy"));
        map.put("reverseArray", AggregationMethodReference.singleArgRef().forOperator("$reverseArray"));
        map.put("reduce", AggregationMethodReference.mapArgRef().forOperator("$reduce").mappingParametersTo("input", "initialValue", "in"));
        map.put("zip", AggregationMethodReference.mapArgRef().forOperator("$zip").mappingParametersTo("inputs", "useLongestLength", "defaults"));
        map.put("in", AggregationMethodReference.arrayArgRef().forOperator("$in"));
        map.put("arrayToObject", AggregationMethodReference.singleArgRef().forOperator("$arrayToObject"));
        map.put("indexOfArray", AggregationMethodReference.arrayArgRef().forOperator("$indexOfArray"));
        map.put("range", AggregationMethodReference.arrayArgRef().forOperator("$range"));
        map.put("map", AggregationMethodReference.mapArgRef().forOperator("$map").mappingParametersTo("input", "as", "in"));
        map.put("let", AggregationMethodReference.mapArgRef().forOperator("$let").mappingParametersTo("vars", "in"));
        map.put("literal", AggregationMethodReference.singleArgRef().forOperator("$literal"));
        map.put("dateAdd", AggregationMethodReference.mapArgRef().forOperator("$dateAdd").mappingParametersTo("startDate", "unit", "amount", "timezone"));
        map.put("dateSubtract", AggregationMethodReference.mapArgRef().forOperator("$dateSubtract").mappingParametersTo("startDate", "unit", "amount", "timezone"));
        map.put("dateDiff", AggregationMethodReference.mapArgRef().forOperator("$dateDiff").mappingParametersTo("startDate", "endDate", "unit", "timezone", "startOfWeek"));
        map.put("dateTrunc", AggregationMethodReference.mapArgRef().forOperator("$dateTrunc").mappingParametersTo("date", "unit", "binSize", "startOfWeek", "timezone"));
        map.put("dayOfYear", AggregationMethodReference.singleArgRef().forOperator("$dayOfYear"));
        map.put("dayOfMonth", AggregationMethodReference.singleArgRef().forOperator("$dayOfMonth"));
        map.put("dayOfWeek", AggregationMethodReference.singleArgRef().forOperator("$dayOfWeek"));
        map.put("year", AggregationMethodReference.singleArgRef().forOperator("$year"));
        map.put("month", AggregationMethodReference.singleArgRef().forOperator("$month"));
        map.put("week", AggregationMethodReference.singleArgRef().forOperator("$week"));
        map.put("hour", AggregationMethodReference.singleArgRef().forOperator("$hour"));
        map.put("minute", AggregationMethodReference.singleArgRef().forOperator("$minute"));
        map.put("second", AggregationMethodReference.singleArgRef().forOperator("$second"));
        map.put("millisecond", AggregationMethodReference.singleArgRef().forOperator("$millisecond"));
        map.put("dateToString", AggregationMethodReference.mapArgRef().forOperator("$dateToString").mappingParametersTo("format", "date"));
        map.put("dateFromString", AggregationMethodReference.mapArgRef().forOperator("$dateFromString").mappingParametersTo("dateString", "format", "timezone", "onError", "onNull"));
        map.put("dateFromParts", AggregationMethodReference.mapArgRef().forOperator("$dateFromParts").mappingParametersTo("year", "month", "day", "hour", "minute", "second", "millisecond", "timezone"));
        map.put("isoDateFromParts", AggregationMethodReference.mapArgRef().forOperator("$dateFromParts").mappingParametersTo("isoWeekYear", "isoWeek", "isoDayOfWeek", "hour", "minute", "second", "millisecond", "timezone"));
        map.put("dateToParts", AggregationMethodReference.mapArgRef().forOperator("$dateToParts").mappingParametersTo("date", "timezone", "iso8601"));
        map.put("isoDayOfWeek", AggregationMethodReference.singleArgRef().forOperator("$isoDayOfWeek"));
        map.put("isoWeek", AggregationMethodReference.singleArgRef().forOperator("$isoWeek"));
        map.put("isoWeekYear", AggregationMethodReference.singleArgRef().forOperator("$isoWeekYear"));
        map.put("tsIncrement", AggregationMethodReference.singleArgRef().forOperator("$tsIncrement"));
        map.put("tsSecond", AggregationMethodReference.singleArgRef().forOperator("$tsSecond"));
        map.put("cond", AggregationMethodReference.mapArgRef().forOperator("$cond").mappingParametersTo("if", "then", "else"));
        map.put("ifNull", AggregationMethodReference.arrayArgRef().forOperator("$ifNull"));
        map.put("sum", AggregationMethodReference.arrayArgRef().forOperator("$sum"));
        map.put("avg", AggregationMethodReference.arrayArgRef().forOperator("$avg"));
        map.put("first", AggregationMethodReference.singleArgRef().forOperator("$first"));
        map.put("last", AggregationMethodReference.singleArgRef().forOperator("$last"));
        map.put("max", AggregationMethodReference.arrayArgRef().forOperator("$max"));
        map.put("min", AggregationMethodReference.arrayArgRef().forOperator("$min"));
        map.put("push", AggregationMethodReference.singleArgRef().forOperator("$push"));
        map.put("addToSet", AggregationMethodReference.singleArgRef().forOperator("$addToSet"));
        map.put("stdDevPop", AggregationMethodReference.arrayArgRef().forOperator("$stdDevPop"));
        map.put("stdDevSamp", AggregationMethodReference.arrayArgRef().forOperator("$stdDevSamp"));
        map.put("covariancePop", AggregationMethodReference.arrayArgRef().forOperator("$covariancePop"));
        map.put("covarianceSamp", AggregationMethodReference.arrayArgRef().forOperator("$covarianceSamp"));
        map.put("bottom", AggregationMethodReference.mapArgRef().forOperator("$bottom").mappingParametersTo("output", "sortBy"));
        map.put("bottomN", AggregationMethodReference.mapArgRef().forOperator("$bottomN").mappingParametersTo("n", "output", "sortBy"));
        map.put("firstN", AggregationMethodReference.mapArgRef().forOperator("$firstN").mappingParametersTo("n", "input"));
        map.put("lastN", AggregationMethodReference.mapArgRef().forOperator("$lastN").mappingParametersTo("n", "input"));
        map.put("top", AggregationMethodReference.mapArgRef().forOperator("$top").mappingParametersTo("output", "sortBy"));
        map.put("topN", AggregationMethodReference.mapArgRef().forOperator("$topN").mappingParametersTo("n", "output", "sortBy"));
        map.put("maxN", AggregationMethodReference.mapArgRef().forOperator("$maxN").mappingParametersTo("n", "input"));
        map.put("minN", AggregationMethodReference.mapArgRef().forOperator("$minN").mappingParametersTo("n", "input"));
        map.put("percentile", AggregationMethodReference.mapArgRef().forOperator("$percentile").mappingParametersTo("input", "p", "method"));
        map.put("median", AggregationMethodReference.mapArgRef().forOperator("$median").mappingParametersTo("input", "method"));
        map.put("type", AggregationMethodReference.singleArgRef().forOperator("$type"));
        map.put("objectToArray", AggregationMethodReference.singleArgRef().forOperator("$objectToArray"));
        map.put("mergeObjects", AggregationMethodReference.arrayArgRef().forOperator("$mergeObjects"));
        map.put("getField", AggregationMethodReference.mapArgRef().forOperator("$getField").mappingParametersTo("field", "input"));
        map.put("setField", AggregationMethodReference.mapArgRef().forOperator("$setField").mappingParametersTo("field", "value", "input"));
        map.put("convert", AggregationMethodReference.mapArgRef().forOperator("$convert").mappingParametersTo("input", "to", "onError", "onNull"));
        map.put("toBool", AggregationMethodReference.singleArgRef().forOperator("$toBool"));
        map.put("toDate", AggregationMethodReference.singleArgRef().forOperator("$toDate"));
        map.put("toDecimal", AggregationMethodReference.singleArgRef().forOperator("$toDecimal"));
        map.put("toDouble", AggregationMethodReference.singleArgRef().forOperator("$toDouble"));
        map.put("toInt", AggregationMethodReference.singleArgRef().forOperator("$toInt"));
        map.put("toLong", AggregationMethodReference.singleArgRef().forOperator("$toLong"));
        map.put("toObjectId", AggregationMethodReference.singleArgRef().forOperator("$toObjectId"));
        map.put("toString", AggregationMethodReference.singleArgRef().forOperator("$toString"));
        map.put("degreesToRadians", AggregationMethodReference.singleArgRef().forOperator("$degreesToRadians"));
        map.put("locf", AggregationMethodReference.singleArgRef().forOperator("$locf"));
        FUNCTIONS = Collections.unmodifiableMap(map);
    }

    public static final class AggregationMethodReference {
        private final @Nullable String mongoOperator;
        private final @Nullable ArgumentType argumentType;
        private final String @Nullable [] argumentMap;

        private AggregationMethodReference(@Nullable String mongoOperator, @Nullable ArgumentType argumentType, String @Nullable [] argumentMap) {
            this.mongoOperator = mongoOperator;
            this.argumentType = argumentType;
            this.argumentMap = argumentMap;
        }

        public @Nullable String getMongoOperator() {
            return this.mongoOperator;
        }

        public @Nullable ArgumentType getArgumentType() {
            return this.argumentType;
        }

        public String[] getArgumentMap() {
            return this.argumentMap != null ? this.argumentMap : new String[]{};
        }

        static AggregationMethodReference singleArgRef() {
            return new AggregationMethodReference(null, ArgumentType.SINGLE, null);
        }

        static AggregationMethodReference arrayArgRef() {
            return new AggregationMethodReference(null, ArgumentType.ARRAY, null);
        }

        static AggregationMethodReference mapArgRef() {
            return new AggregationMethodReference(null, ArgumentType.MAP, null);
        }

        static AggregationMethodReference emptyRef() {
            return new AggregationMethodReference(null, ArgumentType.EMPTY_DOCUMENT, null);
        }

        AggregationMethodReference forOperator(String aggregationExpressionOperator) {
            return new AggregationMethodReference(aggregationExpressionOperator, this.argumentType, this.argumentMap);
        }

        AggregationMethodReference mappingParametersTo(String ... aggregationExpressionProperties) {
            Assert.isTrue((boolean)ObjectUtils.nullSafeEquals((Object)((Object)this.argumentType), (Object)((Object)ArgumentType.MAP)), (String)"Parameter mapping can only be applied to AggregationMethodReference with MAPPED ArgumentType");
            return new AggregationMethodReference(this.mongoOperator, this.argumentType, aggregationExpressionProperties);
        }

        public static enum ArgumentType {
            SINGLE,
            ARRAY,
            MAP,
            EMPTY_DOCUMENT;

        }
    }
}

