/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.aggregation;

import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.mongodb.core.aggregation.Aggregation;
import org.springframework.data.mongodb.core.aggregation.AggregationExpression;
import org.springframework.data.mongodb.core.aggregation.AggregationOperation;
import org.springframework.data.mongodb.core.aggregation.AggregationOperationContext;
import org.springframework.data.mongodb.core.aggregation.Field;
import org.springframework.data.mongodb.core.aggregation.Fields;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class DensifyOperation
implements AggregationOperation {
    private @Nullable Field field;
    private @Nullable List<?> partitionBy;
    private @Nullable Range range;

    protected DensifyOperation(@Nullable Field field, @Nullable List<?> partitionBy, @Nullable Range range) {
        this.field = field;
        this.partitionBy = partitionBy;
        this.range = range;
    }

    public static DensifyOperationBuilder builder() {
        return new DensifyOperationBuilder();
    }

    @Override
    public Document toDocument(AggregationOperationContext context) {
        Assert.notNull((Object)this.field, (String)"Field must be set first");
        Assert.notNull((Object)this.range, (String)"Range must be set first");
        Document densify = new Document();
        densify.put("field", (Object)context.getReference(this.field).getRaw());
        if (!ObjectUtils.isEmpty(this.partitionBy)) {
            densify.put("partitionByFields", this.partitionBy.stream().map(it -> {
                if (it instanceof Field) {
                    Field field = (Field)it;
                    return context.getReference(field).getRaw();
                }
                if (it instanceof AggregationExpression) {
                    AggregationExpression expression = (AggregationExpression)it;
                    return expression.toDocument(context);
                }
                return it;
            }).collect(Collectors.toList()));
        }
        densify.put("range", (Object)this.range.toDocument(context));
        return new Document("$densify", (Object)densify);
    }

    public static interface Range {
        public static DensifyRange bounded(Object lower, Object upper) {
            return new BoundedRange(lower, upper, DensifyUnits.NONE);
        }

        public static DensifyRange full() {
            return new DensifyRange(DensifyUnits.NONE){

                @Override
                Object getBounds(AggregationOperationContext ctx) {
                    return "full";
                }
            };
        }

        public static DensifyRange partition() {
            return new DensifyRange(DensifyUnits.NONE){

                @Override
                Object getBounds(AggregationOperationContext ctx) {
                    return "partition";
                }
            };
        }

        default public Document toDocument() {
            return this.toDocument(Aggregation.DEFAULT_CONTEXT);
        }

        public Document toDocument(AggregationOperationContext var1);
    }

    public static class DensifyOperationBuilder {
        DensifyOperation target = new DensifyOperation(null, Collections.emptyList(), null);

        public DensifyOperationBuilder densify(String fieldname) {
            this.target.field = Fields.field(fieldname);
            return this;
        }

        public DensifyOperationBuilder partitionBy(String ... fields) {
            this.target.partitionBy = Fields.fields(fields).asList();
            return this;
        }

        public DensifyOperationBuilder range(Range range) {
            this.target.range = range;
            return this;
        }

        public DensifyOperationBuilder fullRange(Consumer<DensifyRange> consumer) {
            Assert.notNull(consumer, (String)"Consumer must not be null");
            DensifyRange range = Range.full();
            consumer.accept(range);
            return this.range(range);
        }

        public DensifyOperationBuilder partitionRange(Consumer<DensifyRange> consumer) {
            DensifyRange range = Range.partition();
            consumer.accept(range);
            return this.range(range);
        }

        public DensifyOperation build() {
            return new DensifyOperation(this.target.field, this.target.partitionBy, this.target.range);
        }
    }

    public static enum DensifyUnits implements DensifyUnit
    {
        NONE,
        YEAR,
        QUARTER,
        MONTH,
        WEEK,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MILLISECOND;

    }

    public static interface DensifyUnit {
        public String name();

        public static DensifyUnit from(TimeUnit timeUnit) {
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must not be null");
            switch (timeUnit) {
                case DAYS: {
                    return DensifyUnits.DAY;
                }
                case HOURS: {
                    return DensifyUnits.HOUR;
                }
                case MINUTES: {
                    return DensifyUnits.MINUTE;
                }
                case SECONDS: {
                    return DensifyUnits.SECOND;
                }
                case MILLISECONDS: {
                    return DensifyUnits.MILLISECOND;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot create DensifyUnit from %s", new Object[]{timeUnit}));
        }

        public static DensifyUnits from(ChronoUnit chronoUnit) {
            switch (chronoUnit) {
                case YEARS: {
                    return DensifyUnits.YEAR;
                }
                case WEEKS: {
                    return DensifyUnits.WEEK;
                }
                case MONTHS: {
                    return DensifyUnits.MONTH;
                }
                case DAYS: {
                    return DensifyUnits.DAY;
                }
                case HOURS: {
                    return DensifyUnits.HOUR;
                }
                case MINUTES: {
                    return DensifyUnits.MINUTE;
                }
                case SECONDS: {
                    return DensifyUnits.SECOND;
                }
                case MILLIS: {
                    return DensifyUnits.MILLISECOND;
                }
            }
            throw new IllegalArgumentException(String.format("Cannot create DensifyUnit from %s", chronoUnit));
        }
    }

    public static class BoundedRange
    extends DensifyRange {
        private List<Object> bounds;

        protected BoundedRange(Object lower, Object upper, DensifyUnit unit) {
            super(unit);
            this.bounds = Arrays.asList(lower, upper);
        }

        @Override
        List<Object> getBounds(AggregationOperationContext ctx) {
            return this.bounds.stream().map(it -> {
                if (it instanceof AggregationExpression) {
                    AggregationExpression expression = (AggregationExpression)it;
                    return expression.toDocument(ctx);
                }
                return it;
            }).collect(Collectors.toList());
        }
    }

    public static abstract class DensifyRange
    implements Range {
        private @Nullable DensifyUnit unit;
        private @Nullable Number step;

        public DensifyRange(@Nullable DensifyUnit unit) {
            this.unit = unit;
        }

        @Override
        public Document toDocument(AggregationOperationContext ctx) {
            Document range = new Document("step", (Object)this.step);
            if (this.unit != null && !DensifyUnits.NONE.equals(this.unit)) {
                range.put("unit", (Object)this.unit.name().toLowerCase(Locale.US));
            }
            range.put("bounds", this.getBounds(ctx));
            return range;
        }

        @Contract(value="_ -> this")
        public DensifyRange incrementBy(Number step) {
            this.step = step;
            return this;
        }

        @Contract(value="_, _ -> this")
        public DensifyRange incrementBy(Number step, DensifyUnit unit) {
            this.step = step;
            return this.unit(unit);
        }

        @Contract(value="_ -> this")
        public DensifyRange unit(DensifyUnit unit) {
            this.unit = unit;
            return this;
        }

        abstract Object getBounds(AggregationOperationContext var1);
    }
}

