/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import com.querydsl.core.JoinExpression;
import com.querydsl.core.QueryMetadata;
import com.querydsl.core.QueryModifiers;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.mongodb.MongodbOps;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.ScrollPosition;
import org.springframework.data.domain.Slice;
import org.springframework.data.domain.Window;
import org.springframework.data.mongodb.core.ReactiveFindOperation;
import org.springframework.data.mongodb.core.ReactiveMongoOperations;
import org.springframework.data.mongodb.core.mapping.FieldName;
import org.springframework.data.mongodb.core.query.BasicQuery;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.repository.support.ReactivePageableExecutionUtils;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbQuerySupport;
import org.springframework.data.mongodb.repository.support.SpringDataMongodbSerializer;
import org.springframework.data.mongodb.repository.util.SliceUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class ReactiveSpringDataMongodbQuery<K>
extends SpringDataMongodbQuerySupport<ReactiveSpringDataMongodbQuery<K>> {
    private final ReactiveMongoOperations mongoOperations;
    private final Consumer<BasicQuery> queryCustomizer;
    private final ReactiveFindOperation.FindWithQuery<K> find;

    ReactiveSpringDataMongodbQuery(ReactiveMongoOperations mongoOperations, Class<? extends K> entityClass) {
        this(mongoOperations, entityClass, entityClass, null, it -> {});
    }

    ReactiveSpringDataMongodbQuery(ReactiveMongoOperations mongoOperations, Class<?> domainType, Class<? extends K> resultType, @Nullable String collection, Consumer<BasicQuery> queryCustomizer) {
        super(new SpringDataMongodbSerializer(mongoOperations.getConverter()));
        this.mongoOperations = mongoOperations;
        this.queryCustomizer = queryCustomizer;
        this.find = (StringUtils.hasText((String)collection) ? mongoOperations.query(domainType).inCollection(collection) : mongoOperations.query(domainType)).as(resultType);
    }

    Flux<K> fetch() {
        return this.createQuery().flatMapMany(it -> this.find.matching((Query)it).all());
    }

    Mono<Window<K>> scroll(ScrollPosition scrollPosition) {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).scroll(scrollPosition));
    }

    Mono<Page<K>> fetchPage(Pageable pageable) {
        Mono content = this.createQuery().map(it -> it.with(pageable)).flatMapMany(it -> this.find.matching((Query)it).all()).collectList();
        return content.flatMap(it -> ReactivePageableExecutionUtils.getPage(it, pageable, this.fetchCount()));
    }

    Mono<Slice<K>> fetchSlice(Pageable pageable) {
        Mono content = this.createQuery().map(it -> SliceUtils.limitResult(it, pageable).with(pageable.getSort())).flatMapMany(it -> this.find.matching((Query)it).all()).collectList();
        return content.map(it -> SliceUtils.sliceResult(it, pageable));
    }

    Mono<K> fetchOne() {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).one());
    }

    Mono<K> fetchFirst() {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).first());
    }

    Mono<Long> fetchCount() {
        return this.createQuery().flatMap(it -> this.find.matching((Query)it).count());
    }

    protected Mono<Query> createQuery() {
        QueryMetadata metadata = this.getQueryMixin().getMetadata();
        return this.createQuery(this.createReactiveFilter(metadata), metadata.getProjection(), metadata.getModifiers(), metadata.getOrderBy());
    }

    protected Mono<Query> createQuery(Mono<Predicate> filter, @Nullable Expression<?> projection, QueryModifiers modifiers, List<OrderSpecifier<?>> orderBy) {
        ReactiveSpringDataMongodbQuery reactiveSpringDataMongodbQuery = this;
        return filter.map(x$0 -> reactiveSpringDataMongodbQuery.createQuery((Predicate)x$0)).defaultIfEmpty((Object)this.createQuery(null)).map(it -> {
            Document fields = this.createProjection(projection);
            BasicQuery basicQuery = new BasicQuery((Document)it, fields == null ? new Document() : fields);
            Integer limit = modifiers.getLimitAsInteger();
            Integer offset = modifiers.getOffsetAsInteger();
            if (limit != null) {
                basicQuery.limit(limit);
            }
            if (offset != null) {
                basicQuery.skip(offset.intValue());
            }
            if (orderBy.size() > 0) {
                basicQuery.setSortObject(this.createSort(orderBy));
            }
            this.queryCustomizer.accept(basicQuery);
            return basicQuery;
        });
    }

    protected Mono<Predicate> createReactiveFilter(QueryMetadata metadata) {
        if (!metadata.getJoins().isEmpty()) {
            return this.createReactiveJoinFilter(metadata).map(it -> ExpressionUtils.allOf((Predicate[])new Predicate[]{metadata.getWhere(), it})).switchIfEmpty(Mono.justOrEmpty((Object)metadata.getWhere()));
        }
        return Mono.justOrEmpty((Object)metadata.getWhere());
    }

    protected Mono<Predicate> createReactiveJoinFilter(QueryMetadata metadata) {
        LinkedMultiValueMap predicates = new LinkedMultiValueMap();
        List joins = metadata.getJoins();
        for (int i = joins.size() - 1; i >= 0; --i) {
            JoinExpression join = (JoinExpression)joins.get(i);
            Path source = (Path)((Operation)join.getTarget()).getArg(0);
            Path target = (Path)((Operation)join.getTarget()).getArg(1);
            Collection extraFilters = (Collection)predicates.get((Object)target.getRoot());
            Mono filter = this.allOf(extraFilters).map(it -> ExpressionUtils.allOf((Predicate[])new Predicate[]{join.getCondition(), it})).switchIfEmpty(Mono.justOrEmpty((Object)join.getCondition()));
            Mono predicate = this.getIds(target.getType(), (Mono<Predicate>)filter).collectList().handle((it, sink) -> {
                if (it.isEmpty()) {
                    sink.error((Throwable)new NoMatchException(source));
                    return;
                }
                Path path = ExpressionUtils.path(String.class, (Path)source, (String)"$id");
                sink.next((Object)ExpressionUtils.in((Expression)path, (Collection)it));
            });
            predicates.add((Object)source.getRoot(), (Object)predicate);
        }
        Path source = (Path)((Operation)((JoinExpression)joins.get(0)).getTarget()).getArg(0);
        return this.allOf((Collection)predicates.get((Object)source.getRoot())).onErrorResume(NoMatchException.class, e -> Mono.just((Object)ExpressionUtils.predicate((Operator)MongodbOps.NO_MATCH, (Expression[])new Expression[]{e.source})));
    }

    private Mono<Predicate> allOf(@Nullable Collection<Mono<Predicate>> predicates) {
        return predicates != null ? Flux.concat(predicates).collectList().map(ExpressionUtils::allOf) : Mono.empty();
    }

    protected Flux<Object> getIds(Class<?> targetType, Mono<Predicate> condition) {
        return condition.flatMapMany(it -> this.getJoinIds(targetType, (Predicate)it)).switchIfEmpty((Publisher)Flux.defer(() -> this.getJoinIds(targetType, null)));
    }

    protected Flux<Object> getJoinIds(Class<?> targetType, @Nullable Predicate condition) {
        return this.createQuery((Mono<Predicate>)Mono.justOrEmpty((Object)condition), null, QueryModifiers.EMPTY, Collections.emptyList()).flatMapMany(query -> this.mongoOperations.findDistinct((Query)query, FieldName.ID.name(), targetType, Object.class));
    }

    protected List<Object> getIds(Class<?> aClass, Predicate predicate) {
        throw new UnsupportedOperationException("Use create Flux<Object> getIds(Class<?> targetType, Mono<Predicate> condition)");
    }

    static class NoMatchException
    extends RuntimeException {
        final Path<?> source;

        NoMatchException(Path<?> source) {
            this.source = source;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

