/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb;

import com.mongodb.ClientSessionOptions;
import com.mongodb.ConnectionString;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.mongodb.CodecRegistryProvider;
import org.springframework.data.mongodb.MongoSessionProvider;
import org.springframework.data.mongodb.core.SimpleMongoClientDatabaseFactory;
import org.springframework.util.Assert;

public interface MongoDatabaseFactory
extends CodecRegistryProvider,
MongoSessionProvider {
    public static SimpleMongoClientDatabaseFactory create(String connectionString) {
        Assert.notNull((Object)connectionString, (String)"ConnectionString must not be null");
        return new SimpleMongoClientDatabaseFactory(connectionString);
    }

    public static SimpleMongoClientDatabaseFactory create(ConnectionString connectionString) {
        Assert.notNull((Object)connectionString, (String)"ConnectionString must not be null");
        return new SimpleMongoClientDatabaseFactory(connectionString);
    }

    public static MongoDatabaseFactory create(MongoClient mongoClient, String databaseName) {
        return new SimpleMongoClientDatabaseFactory(mongoClient, databaseName);
    }

    public MongoDatabase getMongoDatabase() throws DataAccessException;

    public MongoDatabase getMongoDatabase(String var1) throws DataAccessException;

    public PersistenceExceptionTranslator getExceptionTranslator();

    @Override
    default public CodecRegistry getCodecRegistry() {
        return this.getMongoDatabase().getCodecRegistry();
    }

    @Override
    public ClientSession getSession(ClientSessionOptions var1);

    default public MongoDatabaseFactory withSession(ClientSessionOptions options) {
        return this.withSession(this.getSession(options));
    }

    public MongoDatabaseFactory withSession(ClientSession var1);

    default public boolean isTransactionActive() {
        return false;
    }
}

