/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.support;

import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.data.mongodb.repository.query.MongoEntityInformation;
import org.springframework.data.mongodb.repository.support.MongoRepositoryFragmentsContributor;
import org.springframework.data.mongodb.repository.support.QuerydslMongoPredicateExecutor;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFragment;

enum QuerydslContributor implements MongoRepositoryFragmentsContributor
{
    INSTANCE;


    @Override
    public RepositoryComposition.RepositoryFragments contribute(RepositoryMetadata metadata, MongoEntityInformation<?, ?> entityInformation, MongoOperations operations) {
        if (QuerydslContributor.isQuerydslRepository(metadata)) {
            QuerydslMongoPredicateExecutor executor = new QuerydslMongoPredicateExecutor(entityInformation, operations);
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.implemented(QuerydslPredicateExecutor.class, executor)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    public RepositoryComposition.RepositoryFragments describe(RepositoryMetadata metadata) {
        if (QuerydslContributor.isQuerydslRepository(metadata)) {
            return RepositoryComposition.RepositoryFragments.of((RepositoryFragment[])new RepositoryFragment[]{RepositoryFragment.structural(QuerydslPredicateExecutor.class, QuerydslMongoPredicateExecutor.class)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private static boolean isQuerydslRepository(RepositoryMetadata metadata) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
    }
}

