/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import java.util.Optional;
import java.util.Set;
import org.bson.Document;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.KeysetScrollPosition;
import org.springframework.data.mongodb.core.query.Collation;
import org.springframework.data.mongodb.core.query.Field;
import org.springframework.data.mongodb.core.query.Meta;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.util.BsonUtils;
import org.springframework.util.StringUtils;

class StringQuery
extends Query {
    private Query delegate;
    private @Nullable String raw;
    private @Nullable String sort;
    private @Nullable String fields;

    public StringQuery(Query query) {
        this.delegate = query;
    }

    public StringQuery(String query) {
        this.delegate = new Query();
        this.raw = query;
    }

    @Nullable String getQueryString() {
        if (StringUtils.hasText((String)this.raw)) {
            return this.raw;
        }
        Document queryObj = this.getQueryObject();
        if (queryObj.isEmpty()) {
            return null;
        }
        return this.toJson(queryObj);
    }

    public Query sort(String sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public Field fields() {
        return this.delegate.fields();
    }

    @Override
    public boolean hasReadConcern() {
        return this.delegate.hasReadConcern();
    }

    @Override
    public @Nullable ReadConcern getReadConcern() {
        return this.delegate.getReadConcern();
    }

    @Override
    public boolean hasReadPreference() {
        return this.delegate.hasReadPreference();
    }

    @Override
    public @Nullable ReadPreference getReadPreference() {
        return this.delegate.getReadPreference();
    }

    @Override
    public boolean hasKeyset() {
        return this.delegate.hasKeyset();
    }

    @Override
    public @Nullable KeysetScrollPosition getKeyset() {
        return this.delegate.getKeyset();
    }

    @Override
    public Set<Class<?>> getRestrictedTypes() {
        return this.delegate.getRestrictedTypes();
    }

    @Override
    public Document getQueryObject() {
        return this.delegate.getQueryObject();
    }

    @Override
    public Document getFieldsObject() {
        return this.delegate.getFieldsObject();
    }

    @Override
    public Document getSortObject() {
        return this.delegate.getSortObject();
    }

    @Override
    public boolean isSorted() {
        return this.delegate.isSorted() || StringUtils.hasText((String)this.sort);
    }

    @Override
    public long getSkip() {
        return this.delegate.getSkip();
    }

    @Override
    public boolean isLimited() {
        return this.delegate.isLimited();
    }

    @Override
    public int getLimit() {
        return this.delegate.getLimit();
    }

    @Override
    public @Nullable String getHint() {
        return this.delegate.getHint();
    }

    @Override
    public Meta getMeta() {
        return this.delegate.getMeta();
    }

    @Override
    public Optional<Collation> getCollation() {
        return this.delegate.getCollation();
    }

    @Nullable String getSortString() {
        if (StringUtils.hasText((String)this.sort)) {
            return this.sort;
        }
        Document sort = this.getSortObject();
        if (sort.isEmpty()) {
            return null;
        }
        return this.toJson(sort);
    }

    @Nullable String getFieldsString() {
        if (StringUtils.hasText((String)this.fields)) {
            return this.fields;
        }
        Document fields = this.getFieldsObject();
        if (fields.isEmpty()) {
            return null;
        }
        return this.toJson(fields);
    }

    StringQuery fields(String fields) {
        this.fields = fields;
        return this;
    }

    String toJson(Document source) {
        return BsonUtils.writeJson(source).toJsonString();
    }
}

